% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{ABAmodelCombineStrata}
\alias{ABAmodelCombineStrata}
\title{Combines a list of ABA models into a single ABA model object}
\usage{
ABAmodelCombineStrata(model.list, plotsId = NULL)
}
\arguments{
\item{model.list}{list. stratum-specific models returned by \code{\link{ABAmodel}}}

\item{plotsId}{vector. "plotsId" for ordering row names in the "values" element of the output list}
}
\value{
a list with three elements
\itemize{
\item \code{model}: a list of regression models corresponding to each stratum (output from \code{\link[stats]{lm}}),
\item \code{stats}:model statistics of each stratum-specific model (as in \code{\link{ABAmodel}}) plus one line corresponding to statistics for all strata (COMBINED)
\item \code{values}: data.frame with observed and values predicted in cross-validation, and information on which stratum it belongs to.
}
}
\description{
Combines a list of models (obtained with \code{\link{ABAmodel}}) into a single object. Typically used to merge stratum-specific models into one object. Validation statistics are computed for the combined strata, making it easier to compare prediction performance with an unstratified model.
}
\examples{
# load Quatre Montagnes dataset
data(quatremontagnes)
# initialize list of models
model.ABA.stratified <- list()
# calibrate basal area prediction model for each stratum
for (i in levels(quatremontagnes$stratum))
{
  subsample <- which(quatremontagnes$stratum==i)
  model.ABA.stratified[[i]] <-
  ABAmodel(quatremontagnes[subsample, "G.m2.ha"],
  quatremontagnes[subsample, 9:76], transform="boxcox", nmax=4,
  xy = quatremontagnes[subsample,c("X", "Y")])
}
# combine models in single object
model.ABA.stratified <- ABAmodelCombineStrata(model.ABA.stratified,
quatremontagnes$plotId)
# display content of output list
model.ABA.stratified$model
model.ABA.stratified$stats
summary(model.ABA.stratified$values)

# plot field values VS predictions in cross-validation
ABAmodelPlot(model.ABA.stratified)
}
\seealso{
\code{\link{ABAmodel}} for calibrated ABA model, \code{\link{ABAmodelPlot}} for plotting model cross-validation results.
}
