% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregistration.R
\name{rastersMovingCor}
\alias{rastersMovingCor}
\title{Correlation between rasters for different XY translations}
\usage{
rastersMovingCor(raster.b, raster.s, mask = NULL, buffer = 19, step = 0.5)
}
\arguments{
\item{raster.b}{raster. raster to correlate with largest extent}

\item{raster.s}{raster. raster to correlate with smallest extent}

\item{mask}{raster. mask of area to correlate, applied to small raster}

\item{buffer}{numeric. radius of the circular buffer area for possible translations}

\item{step}{numeric. increment step of translations within buffer area to compute correlation values, should be a multiple of raster resolution}
}
\value{
A raster. Raster value at coordinates x,y correspond to the correlation between the large raster and the small raster when small raster center has been translated of (x,y)
}
\description{
computes correlation between two rasters for different XY translations. The correlation values are computed on the extent of the smallest raster using \code{\link{rasters2Cor}}, after applying an optional mask, and for each translation within a buffer area.
}
\examples{
# create raster
r.b <- raster::raster()
raster::extent(r.b) <- c(0,40,0,40)
raster::res(r.b) <- 1
xy <- raster::xyFromCell(r.b,1:length(r.b))

# add Gaussian surfaces
z1 <- 1.5*exp(-((xy[,1]-22)^2+(xy[,2]-22)^2/2)/5)
z2 <- exp(-((xy[,1]-20)^2+(xy[,2]-22)^2/2)/3)
z3 <- 1.5*exp(-((xy[,1]-17)^2+(xy[,2]-17)^2/2)/5)
r.b <- raster::rasterFromXYZ(cbind(xy,z1+z2+z3))

# create small raster
r.s <- raster::crop(r.b, raster::extent(c(15,25,15,25)))
# offset raster by (-2, -2)
raster::extent(r.s) <- c(13,23,13,23)

# compute correlations for translations inside buffer
rr <- rastersMovingCor(r.b, r.s, buffer=6, step=1)
rr

# display large raster
raster::plot(r.b, main="Large raster")
# display small raster
raster::plot(r.s, main="Small raster")
# display correlation
raster::plot(rr, xlab="X translation", ylab="Y translation",
main="Correlation between rasters")
}
\seealso{
\code{\link{rasterLocalmax}} to extract local maximum of resulting correlation raster, \code{\link{rasters2Cor}}
}
