% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Dataset.R
\name{lgb.Dataset.save}
\alias{lgb.Dataset.save}
\title{Save \code{lgb.Dataset} to a binary file}
\usage{
lgb.Dataset.save(dataset, fname)
}
\arguments{
\item{dataset}{object of class \code{lgb.Dataset}}

\item{fname}{object filename of output file}
}
\value{
the dataset you passed in
}
\description{
Please note that \code{init_score} is not saved in binary file.
             If you need it, please set it again after loading Dataset.
}
\examples{
\donttest{
\dontshow{setLGBMthreads(2L)}
\dontshow{data.table::setDTthreads(1L)}
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
lgb.Dataset.save(dtrain, tempfile(fileext = ".bin"))
}
}
