% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_RR.R
\name{L_RR}
\alias{L_RR}
\title{Likelihood Support for Relative Risk (RR)}
\usage{
L_RR(table, null=1, exp.RR=NULL, L.int=2, alpha=0.05,
cc=FALSE, toler=0.0001, logplot=FALSE, supplot=-10, verb=TRUE)
}
\arguments{
\item{table}{a 2 x 2 matrix or contingency table containing counts.}

\item{null}{the value against which the obtained RR is tested, default = 1.}

\item{exp.RR}{an expected or hypothetical RR.}

\item{L.int}{likelihood interval given as support values, e.g. 2 or 3, default = 2.}

\item{alpha}{the significance level used, 1 - alpha interval calculated, default = 0.05.}

\item{cc}{logical indicating whether to apply continuity correction, default = FALSE.}

\item{toler}{the desired accuracy using optimise, default = 0.0001.}

\item{logplot}{plot vertical axis as log likelihood, default = FALSE}

\item{supplot}{set minimum likelihood display value in plot, default = -10}

\item{verb}{show output, default = TRUE.}
}
\value{
$S.val - support for observed RR from expected.

$df - degrees of freedom.

$exp.RR - expected RR.

$S.exp.RRvsObs - support for expected RR versus observed.

$S.exp.RRvsNull - support for expected RR versus the null.

$L.int - likelihood interval of observed RR for specified level of support.

$S_int - specified likelihood interval in units of support.

$observed - observed frequencies.

$expected - the expected values for null hypothesis of no interaction.

$chi.sq - chi-squared statistic.

$corrected - whether chi-squared was corrected, default = FALSE.

$p.value - p value.

$residuals - the Pearson residuals.

$alpha - specified significance level.

$conf.int - likelihood-based confidence interval for observed RR.

$all.err.acc - error accuracy for each application of the optimize function.
}
\description{
This function calculates the support for an RR from a 2 x 2 categorical data table.
An expected RR can be specified and the support calculated for this relative to the observed
and null (which is assumed to be 1, but can also be specified) values. A likelihood function
is plotted for the obtained RR with a likelihood interval, and expected RR,
if specified. The log likelihood plot can optionally be given instead.
Chi-squared statistics are also provided and a likelihood-based \% confidence interval.
It uses the optimize function to locate desired limits for both intervals and other
support calculations.
}
\examples{
# for folic acid and neural tube defects example
tab <- as.table(rbind(c(6,587),c(21,581)))
dimnames(tab) <- list(Treatment=c("Folic acid","None"),Defect=c("Yes","No"))
L_RR(tab, exp.RR = 0.5, L.int = 2, alpha=0.05, cc=FALSE,
toler=0.0001, logplot=FALSE, supplot=-10, verb=TRUE)

# S. Korea COVID-19 patient mortality
tabcor <- as.table(rbind(c(41,3095),c(34,4992)))
dimnames(tabcor) <- list(Sex=c("Male","Female"),Status=c("Dead","Alive"))
L_RR(tabcor, exp.RR = 0.5, L.int = 2, alpha=0.05, cc=FALSE, toler=0.0001,
logplot=FALSE, supplot=-10, verb=TRUE)

}
\references{
Aitkin, M. et al (1989) Statistical Modelling in GLIM, Clarendon Press, ISBN : 978-0198522041

Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

Royall, R. M. (1997). Statistical evidence: A likelihood paradigm. London: Chapman & Hall, ISBN : 978-0412044113

Edwards, A.W.F. (1992) Likelihood, Johns Hopkins Press, ISBN : 978-0801844430

Dienes, Z. (2008) Understanding Psychology as a Science: An Introduction to Scientific and Statistical
Inference, Palgrave, MacMillan, ISBN : 978-0230542303
}
\keyword{Likelihood;}
\keyword{confidence}
\keyword{interval}
\keyword{interval;}
\keyword{likelihood}
\keyword{relative}
\keyword{risk;}
\keyword{support;}
