% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/square_bracket.R
\name{[.linelist}
\alias{[.linelist}
\alias{sub_linelist}
\alias{[<-.linelist}
\alias{[[<-.linelist}
\title{Subsetting of linelist objets}
\usage{
\method{[}{linelist}(x, i, j, drop = FALSE)

\method{[}{linelist}(x, i, j) <- value

\method{[[}{linelist}(x, i, j) <- value
}
\arguments{
\item{x}{a \code{linelist} object}

\item{i}{a vector of \code{integer} or \code{logical} to subset the rows of the
\code{linelist}}

\item{j}{a vector of \code{character}, \code{integer}, or \code{logical} to subset the
columns of the \code{linelist}}

\item{drop}{a \code{logical} indicating if, when a single column is selected, the
\code{data.frame} class should be dropped to return a simple vector, in which
case the \code{linelist} class is lost as well; defaults to \code{FALSE}}

\item{value}{the replacement to be used for the entries identified in \code{x}}
}
\value{
If no drop is happening, a \code{linelist}. Otherwise an atomic vector.
}
\description{
The \verb{[]} and \verb{[[]]} operators for \code{linelist} objects behaves like for regular
\code{data.frame} or \code{tibble}, but check that tagged variables are not lost, and
takes the appropriate action if this is the case (warning, error, or ignore,
depending on the general option set via \code{\link[=lost_tags_action]{lost_tags_action()}}) .
}
\examples{
if (require(outbreaks) && require(dplyr) && require(magrittr)) {
  ## create a linelist
  x <- measles_hagelloch_1861 \%>\%
    tibble() \%>\% 
    make_linelist(id = "case_ID",
                  date_onset = "date_of_prodrome",
                  age = "age",
                  gender = "gender") \%>\%
    mutate(result = if_else(is.na(date_of_death), "survived", "died")) \%>\%
    set_tags(outcome = "result") \%>\%
    rename(identifier = case_ID)
  x

  ## dangerous removal of a tagged column setting it to NULL issues a warning
  x[, 1] <- NULL
  x

  x[[2]] <- NULL
  x
}
}
\seealso{
\itemize{
\item \code{\link[=lost_tags_action]{lost_tags_action()}} to set the behaviour to adopt when tags are
lost through subsetting; default is to issue a warning
\item \code{\link[=get_lost_tags_action]{get_lost_tags_action()}} to check the current the behaviour
}
}
\author{
Thibaut Jombart \email{thibaut@data.org}
}
