% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGP.R
\name{create.lineqGP}
\alias{create.lineqGP}
\title{Creation Method for the \code{"lineqGP"} S3 Class}
\usage{
\method{create}{lineqGP}(x, y, constrType)
}
\arguments{
\item{x}{a vector or matrix with the input data. The dimensions should be indexed by columns.}

\item{y}{a vector with the output data.}

\item{constrType}{a character string corresponding to the type of the inequality constraint.
Options: "boundedness", "monotonicity", "convexity", "linear";
Multiple constraints can be also defined, e.g. \code{constrType = c("boundedness", "monotonicity")}.}
}
\value{
A list with the following elements.
\item{x,y,constrType}{see \bold{Arguments}.}
\item{d}{a number corresponding to the input dimension.}
\item{constrIdx}{for d > 1, a logical vector with the indices of active constrained dimensions.}
\item{localParam}{a list with specific parameters required for \code{"lineqGP"} models:
\code{m} (number of basis functions), \code{sampler}, and \code{samplingParams}.
See \code{\link{simulate.lineqGP}}.}
\item{kernParam}{a list with the kernel parameters: \code{par} (kernel parameters), \code{type}, \code{nugget}.
See \code{\link{kernCompute}}}
\item{bounds}{the limit values if \code{constrType = "boundedness"}.}
\item{(Lambda,lb,ub)}{the linear system of inequalities if \code{constrType = "linear"}.}
}
\description{
Creation method for the \code{"lineqGP"} S3 class.
}
\examples{
# creating the model
sigfun <- function(x) return(1/(1+exp(-7*(x-0.5))))
x <- seq(0, 1, length = 5)
y <- sigfun(x)
model <- create(class = "lineqGP", x, y, constrType = "monotonicity")
model

}
\references{
Lopez-Lopera, A. F., Bachoc, F., Durrande, N., and Roustant, O. (2018),
"Finite-dimensional Gaussian approximation with linear inequality constraints".
\emph{SIAM/ASA Journal on Uncertainty Quantification}, 6(3): 1224-1255.
\href{https://doi.org/10.1137/17M1153157}{[link]}
}
\seealso{
\code{\link{augment.lineqGP}}, \code{\link{predict.lineqGP}}, \code{\link{simulate.lineqGP}}
}
\author{
A. F. Lopez-Lopera.
}
