% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expr1-data.R
\docType{data}
\name{expr-data}
\alias{expr-data}
\alias{expr1}
\alias{expr2}
\title{Example gene expression data}
\format{A matrix of integers, individuals as rows and genes as columns.}
\usage{
data(expr1)
data(expr2)
}
\description{
Matrices of simulated gene expression data, each for 98 individuals
at 5,000 genes. Think of \code{expr1} and \code{expr2} as
expression data on two different tissues.
}
\examples{
data(expr1)
data(expr2)

# identify the common individuals
id <- findCommonID(rownames(expr1), rownames(expr2))

# correlation between tissues for each gene
rho <- corbetw2mat(expr1[id$first,], expr2[id$second,])
hist(rho, breaks=100)
}
\seealso{
\code{\link{genepos}}, \code{\link{f2cross}}, \code{\link{pmap}}
}
\keyword{datasets}

