[![Travis-CI Build Status](https://travis-ci.org/r-spatial/link2GI.svg?branch=master)](https://travis-ci.org/r-spatial/link2GI)
<a href="https://cran.r-project.org/web/checks/check_results_link2GI.html"><img border="0" src="http://www.r-pkg.org/badges/version/link2GI" alt="CRAN version"></a>
![](https://cranlogs.r-pkg.org/badges/grand-total/link2GI?color=green)

[![License](https://img.shields.io/badge/license-GPL%20%28%3E=%203%29-lightgrey.svg?style=flat)](http://www.gnu.org/licenses/gpl-3.0.html)

# link2GI

`link2GI` provide some functions which make it a bit easier to connect straightforward the common open source GI software packages to the R-biotop. It supports both the use of wrapper packages and the direct API-use via system calls. It focuses on `Linux` and `WindowsX` operating systems but nevertheless it should also work with `OSX`.

To utilize the power of the open source GI tools from within `R` you need to install  them first. As a first promising opportunity to do fullfil most of the requirements you may install `QGIS, GRASS`- and `SAGA-GIS` following the excellent [installation instructions](https://github.com/jannes-m/RQGIS/blob/master/vignettes/install_guide.Rmd)  of the [RQGIS](https://CRAN.R-project.org/package=RQGIS) package will have a good first try to ensure a smooth working environment. Note: for most of the cases you may use just `RQGIS` as wrapper for the `QGIS` related functionality. 

If you have several versions installed or if you want to use the full power of the GI software it will be a nice and helpful tool to deal with some strange behaviours and requirements. Especially helpful is the support of `OTB`, the `GDAL-Python` functions and a simple support to use any `SAGA` version via the CLI. Hopefully `RSAGA` and [`Rsagacmd`](https://github.com/stevenpawley/Rsagacmd) will join forces in one package in the future. Anyway the brand new release 1.2.0 of  `RSAGA` as well as the current `Rsagacmd` will work with the environment settings as provided by `linkSAGA`.


# Installation

`link2GI`is up to CRAN. For the installation of the stable version please use `install.packages("link2GI")`. 

To install the  cutting edge version use:
```r
# devtools package
devtools::install_github("r-spatial/link2GI", ref = "develop")
# remotes package
remotes::install_github("r-spatial/link2GI",ref = "develop")
```
# Documentation

#### Updated OTB wrapper

the OTB wrapper is updated for a more convinient usage. Please have a look at the usecase below:

```r

## link to OTB
otblink<-link2GI::linkOTB()

## get data
setwd(tempdir())
## get some typical data as provided by the authority
url<-'http://www.ldbv.bayern.de/file/zip/5619/DOP%2040_CIR.zip'
res <- curl::curl_download(url, "testdata.zip")
unzip(res,junkpaths = TRUE,overwrite = TRUE)

## for the example we use the edge detection, 
algoKeyword<- "EdgeExtraction"

## extract the command list for the choosen algorithm 
cmd<-parseOTBFunction(algo = algoKeyword, gili = otblink)


## define the mandantory arguments all other will be default
cmd$input  <- file.path(getwd(),"4490600_5321400.tif")
cmd$filter <- "touzi"
cmd$out <- paste0(getwd(),"/out",cmd$filter,".tif")

## run algorithm
retStack<-runOTB(cmd,gili = otblink)

## plot raster
raster::plot(retStack)

```


[Online Vignettes](https://gisma.github.io/link2GI/)


### Usecases presented on the GEOSTAT August 2018

During the [GEOSTAT 2018](http://opengeohub.org/node/146) in Prague some more complex usescases have been presented.

#### Find slides and materials
- [Presentation slides](https://gisma.github.io/link2gi2018/link2gi2018.html#1)
- [Github Repository](https://github.com/gisma/link2gi2018)


#### The examples

- Basic usage of SAGA and OTB calls - [SAGA & OTB basic usecase](https://github.com/gisma/link2gi2018/blob/master/R/usecases/saga-otb/useCaseSAGA-OTB.R)
- Wrapping a [GRASS GIS example](https://neteler.gitlab.io/grass-gis-analysis/02_grass-gis_ecad_analysis/) of Markus Neteler as presented on GEOSTAT 2018 - [Analysing the ECA&D climatic data - reloaded](https://github.com/gisma/link2gi2018/blob/master/R/usecases/grass/useCaseGRASS-Neteler2018.R)
- Performing a GRASS based cost analysis on a huge cost raster - [Beetle spread over high asia](https://github.com/gisma/link2gi2018/blob/master/R/usecases/cost-analysis/useCaseBeetle.R)
- Deriving a canopy height model using a mixed API approach - [Canopy Height Model from UAV derived point clouds](https://github.com/gisma/link2gi2018/blob/master/R/usecases/uav-pc/useCaseCHM.R)
