% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grass7Control.R
\name{setenvGRASSw}
\alias{setenvGRASSw}
\title{Usually for internally usage, create valid 'GRASS GIS 7.xx' rsession environment settings according to the selected GRASS GIS 7.x and Windows Version}
\usage{
setenvGRASSw(
  root_GRASS = NULL,
  grass_version = NULL,
  installation_type = NULL,
  jpgmem = 1e+06,
  quiet = TRUE
)
}
\arguments{
\item{root_GRASS}{grass root directory i.e. "C:\\OSGEO4~1",}

\item{grass_version}{grass version name i.e. "grass-7.0.5"}

\item{installation_type}{two options "osgeo4w" as installed by the 'OSGeo4W'-installer and "NSIS" that is typical for a stand_alone installtion of 'GRASS GIS'.}

\item{jpgmem}{jpeg2000 memory allocation size. Default is 1000000}

\item{quiet}{boolean  switch for supressing console messages default is TRUE}
}
\description{
Initializes and set up  access to 'GRASS GIS 7.xx' via the \code{rgrass7} wrapper or command line packages. Set and returns all necessary environment variables and additionally returns the GISBASE directory as string.
}
\examples{
\dontrun{
# set choosen'GRASS GIS' installation folders 
setenvGRASSw(root_GRASS = "C:\\PROGRA~1\\QGIS2~1.18",
             grass_version =  "grass-7.2.1",
             installation_type =  "osgeo4W")
}
}
\author{
Chris Reudenbach
}
