% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grassControl.R
\name{paramGRASSx}
\alias{paramGRASSx}
\title{Usually for internally usage, get 'GRASS GIS' and \code{rgrass} parameters on 'Linux' OS}
\usage{
paramGRASSx(
  set_default_GRASS = NULL,
  MP = "/usr/bin",
  ver_select = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{set_default_GRASS}{default = NULL will force a search for 'GRASS GIS' You may provide a valid combination as 
c("/usr/lib/grass74","7.4.1","grass74")}

\item{MP}{mount point to be searched. default is "/usr/bin"}

\item{ver_select}{if TRUE you must interactivley selcect between alternative installations}

\item{quiet}{boolean  switch for supressing console messages default is TRUE}
}
\description{
Initialize and set up \code{rgrass}  for 'Linux'
}
\details{
During the rsession you will have full access to GRASS7 GIS via the \code{rgrass} wrappe. Additionally you may use also use the API calls of GRASS7 via the command line.
}
\examples{

run = FALSE
if (run) {
# automatic retrieval of the GRASS7 enviroment settings
paramGRASSx()


# typical stand_alone installation
paramGRASSx("/usr/bin/grass72")

# typical user defined installation (compiled sources)
paramGRASSx("/usr/local/bin/grass72")
}
}
