% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_group_code}
\alias{get_group_code}
\title{Extract Litter Group Code}
\usage{
get_group_code(x)
}
\arguments{
\item{x}{\code{character} vector containg litter group codes}
}
\value{
\code{character} vector of litter group codes
}
\description{
Extracts litter group code (i.e., a code in square brackets),
from a \code{character} vector.
}
\examples{
# valid litter type
stopifnot(get_group_code("[TA]") == "[TA]")
stopifnot(get_group_code("all kinds of plastic [PLASTIC]") == "[PLASTIC]")
stopifnot(is.na(get_group_code("all kinds of plastic [Plastic]")))
}
