% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lllcrc}
\alias{lllcrc}
\title{Local log-linear models (LLLMs) for capture-recapture (CRC)}
\usage{
lllcrc(dat, kfrac, models = NULL, ic = "BICpi", bw = NULL,
  averaging = FALSE, cell.adj = TRUE, round.vars = NULL,
  rounding.scale = 0.01, boot.control = NULL)
}
\arguments{
\item{dat}{Capture-recapture data, as output of \code{\link{formatdata}}}

\item{kfrac}{The approximate fraction of the data that is included in the
support of the kernel for the local averages.}

\item{models}{A list of models -- or an expression that returns a
list of models -- to be considered in local model search.  The default is \code{NULL},
and in this case \code{\link{make.hierarchical.term.sets}(k = attributes(dat)$k)}
is called to generate all hierarchical models that include all main effects.}

\item{ic}{The information criterion for selection of local log-linear
models.  The default, BICpi, appears in Hook and Regal (1997).}

\item{bw}{A single-column matrix with rownames that match the covariate
names in \code{dat}.  The values in the column are scalars that are used in
constructing distances between covariate vectors.  Raw differences are
divided by the corresponding scalars before being squared in the context of
a Euclidean metric.  Defaults to a column of 1's.}

\item{averaging}{Logical: Should model averaging be done for each local
model?}

\item{cell.adj}{Logical: Whether to adjust the cells as in Evans and Bonett
(1994).  TRUE by default.}

\item{round.vars}{See \code{\link{micro.post.stratify}}, which is called within
\code{lllcrc}.}

\item{rounding.scale}{See \code{\link{micro.post.stratify}}, which is called within
\code{lllcrc}.}

\item{boot.control}{A list of control parameters for bootstrapping the
sampling distribution of the estimator(s).  By default, there is no
bootstrapping.}
}
\value{
\item{est}{A point estimate of the population size}
\item{llform}{The set of log-linear terms} \item{dat}{The output of function
\code{micro.post.stratify}, with estimated local rates of missingness
appended as an extra column labeled \code{pi0}.  In addition, \code{mct}
(multinomial cell count) gives the number of observed units with that
distinct covariate vector, and \code{cpi0} (cumulative number missing) gives
the the product of \code{pi0} with \code{mct}, such that summing over this
vectorized product is exactly the Horvitz-Thompson style sum in capture
recapture. } \item{ess}{The local effective sample sizes that are based on
the local averaging weights and used as eta_i in local model selection}
\item{hpi}{The matrix of local averages} \item{...}{The output is of class
\code{lllcrc} and has attributes \code{cont.x} and \code{conteg.x}, which
relate the continuous and categorical variables in the model }
}
\description{
Fits local log-linear models.  Each distinct covariate vector gets its own
model.  To reduce the number of models, some rounding of continuous
covariates is done first.
}
\details{
The key implementation of the thesis of Kurtz 2013, Carnegie Mellon
University
}
\author{
Zach Kurtz
}
\references{
Kurtz ZT (2013). "Smooth Post-Stratification for Multiple
Capture-Recapture." \emph{arXiv preprint arXiv:1302.0890}.

Anderson DR and Burnham KP (1999). "Understanding information criteria
for selection among capture-recapture or ring recovery models." \emph{Bird
Study}, \bold{46}(S1), pp. S14-S21.

Fienberg SE (1972). "The Multiple Recapture Census for Closed
Populations and Incomplete $2^k$ Contingency Tables." \emph{Biometrika},
\bold{59}(3), pp. 591.

Evans MA and Bonett DG (1994). "Bias Reduction for Multiple-Recapture
Estimators of Closed Population Size." \emph{Biometrics}, \bold{50}(2), pp.
388-395.
}

