% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast.R
\docType{class}
\name{Forecast-class}
\alias{Forecast-class}
\title{S4 class for storing forecasts}
\description{
An S4 class for storing forecasts. An object of the Forecast class has equal
length vectors that contain the time the forecast was made, the future time
being forecasted, the forecast, and realized values if available. Optionally
includes the number of periods ahead being forecasted.
}
\section{Slots}{

\describe{
\item{\code{origin}}{A vector of any class representing the time when the forecast
was made.}

\item{\code{future}}{A vector of any class representing the time that is being
forecasted, i.e. when the forecast will be realized.}

\item{\code{forecast}}{A numeric vector of forecasts.}

\item{\code{realized}}{Optional numeric vector of realized values, i.e. the true
value at the future time.}

\item{\code{h_ahead}}{Optional length-one object representing the number of periods
ahead being forecasted.}
}}

\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
