% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis_functions.R
\name{pq.diagnostics}
\alias{pq.diagnostics}
\title{Performs phenotypic data quality diagnostics.}
\usage{
pq.diagnostics (crossobj, boxplot = TRUE, qqplot = FALSE,
scatterplot = TRUE,heatplot = TRUE)
}
\arguments{
\item{crossobj}{An object of class = cross obtained from the qtl.cross
function from this package, or the read.cross
function from r/qtl package (Broman and Sen, 2009).
This file contains phenotypic means, genotypic marker score, and genetic map.}

\item{boxplot}{Indicates whether a boxplot should be performed.
TRUE/FALSE term. TRUE is set as default.}

\item{qqplot}{Indicates whether a qqplot should be performed.
TRUE/FALSE term. FALSE is set as default.}

\item{scatterplot}{Indicates whether a scatterplot should be performed.
TRUE/FALSE term. TRUE is set as default.}

\item{heatplot}{Indicates whether a phenotypic heatplot should be performed.
TRUE is set as default.}
}
\value{
It returns: Boxplot, Scatterplot, QQplot, Heatplot
}
\description{
Performs phenotypic data quality diagnostic of an object of class cross
created by the qtl.cross function, including summary descriptive
diagnostics, correlation across traits,and distribution of traits.
}
\details{
Performs reports in the work directory.
}
\note{
Could be performed for QTL analysis in order to analyze
the phenotypic data quality.
}
\examples{
\dontrun{
data (SxM_geno)
data (SxM_map)
data (SxM_pheno)

P.data <- SxM_pheno
G.data <- SxM_geno
map.data <- SxM_map

cross.data <- qtl.cross (P.data, G.data, map.data,
cross='dh', heterozygotes = FALSE)

summary (cross.data)
jittermap (cross.data)

Pheno Quality
pq.diagnostics (crossobj=cross.data)
}
}
\author{
Lucia Gutierrez
}
\references{
Broman KW, Sen S (2009) A Guide to QTL Mapping with R/qtl.
            Springer, NewYork.
            Comadran J, Thomas W, van Eeuwijk F, Ceccarelli S, Grando S, Stanca A,
            Pecchioni N, Akar T, Al-Yassin A, Benbelkacem A, Ouabbou H, Bort J,
            Romagosa I, Hackett C, Russell J (2009) Patterns of genetic diversity
            and linkage disequilibrium in a highly structured Hordeum vulgare
            association-mapping population for the Mediterranean basin.
            Theor Appl Genet 119:175-187
            Milne et al., (2010) Flapjack - graphical genotype visualization.
            Bioinformatics 26(24), 3133-3134.
}
\seealso{
qtl.cross
}

