% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimability.R
\name{is_estimable}
\alias{is_estimable}
\title{Estimability of Contrasts}
\usage{
is_estimable(contrast, nullspace = NULL, X = NULL,
  tol = sqrt(.Machine$double.eps))
}
\arguments{
\item{contrast}{a numeric matrix where each row is a contrast vector for
which estimability is computed. The matrix should have as many columns as
there are columns in the design matrix (which equals the number of
coefficients). If \code{contrast} is a vector it is coerced to a matrix.}

\item{nullspace}{the nullspace of the design matrix.}

\item{X}{design matrix.}

\item{tol}{tolerance for determining if a contrast is orthogonal to the}
}
\value{
a logical vector of length \code{nrow(contrast)} determining if each
contrast is estimable
}
\description{
Computes the estimability of a vector or matrix of contrasts (i.e. linear
functions of the coefficients) from the nullspace of a design matrix or
potentially directly from the design matrix.
}
\examples{

# FIXME: We need some examples here

}
\seealso{
\code{\link{nullspace}}
}
\author{
Rune Haubo B. Christensen
}
\keyword{internal}
