% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-support.R
\name{LMK_euD}
\alias{LMK_euD}
\title{Euclidean Distance}
\usage{
LMK_euD(A1, A2)
}
\arguments{
\item{A1}{A 3D landmark array in the form p x k x n}

\item{A2}{A second 3D landmark array in the form p x k x n}
}
\value{
Returns a list (3L) containing the direct Euclidean distance for all individuals/landmarks, as well as summarized by individual and landmark
}
\description{
Calculate Euclidean distance between two sets of 3D landmark data. Data should be in the typical p x k x n array.
}
\examples{

lmks1 <- cbind(1:10, 1:10, 1:10)
lmks2 <- lmks1*10

LMK_euD(lmks1,lmks2) ## distance between each landmark (1 through 10)

LMK_euD(lmks1[1,], lmks2[1,]) ## distance between a single landmark


}
