% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qua.R
\name{qua}
\alias{qua}
\title{Generic function for \code{qua...}: probabilily distribution fitting with L-Moments}
\usage{
qua(para, f, probability_distribution_attrname = "probability_distrib", ...)
}
\arguments{
\item{f, para, ...}{L-moments and further parameters for \code{qua...}}

\item{probability_distribution_attrname}{attribute name for probability distribution}
}
\description{
Generic function for \code{qua...}: probabilily distribution fitting with L-Moments
}
\examples{

# Sample L-moments of Ozone from the airquality data
data(airquality)
lmom <- samlmu(airquality$Ozone,nmom=6)

distrib <- c("exp","gam","gev","glo","gpa","gno","gum","kap","ln3","nor",
	"pe3","wak","wei")

para_list <- pel(distrib=distrib,lmom=lmom)
f <- (1:10)/10
qua_list <- qua(para=para_list,f=f)


}
\seealso{
\code{\link{pel}},\code{\link{quaexp}},\code{\link{quagam}},\code{\link{quagev}},\code{\link{quaglo}},\code{\link{quagpa}},\code{\link{quagno}},\code{\link{quagum}},

\code{\link{quakap}},\code{\link{qualn3}},\code{\link{quanor}},\code{\link{quape3}},
\code{\link{quawak}},\code{\link{quawei}}
}
