\name{parln3}
\alias{parln3}
\title{Estimate the Parameters of the 3-Parameter Log-Normal Distribution}
\description{
This function estimates the parameters of the Log-Normal3 distribution given
the L-moments of the data in an L-moment object such as that returned by
\code{lmom.ub}. The relation between distribution parameters and L-moments
is seen under \code{lmomln3}. The function uses algorithms of the Generalized
Normal for core computations. Also, if \eqn{\tau_3 \le 0}, then the Log-Normal3
distribution can not be fit, however reversing the data alleviates this problem.
}
\usage{
parln3(lmom, zeta=NULL, checklmom=TRUE)
}
\arguments{
  \item{lmom}{A L-moment object created by \code{\link{lmom.ub}}
or \code{\link{pwm2lmom}}.}
  \item{zeta}{Lower bounds, if \code{NULL} then solved for.}
  \item{checklmom}{Should the \code{lmom} be checked for validity using the \code{are.lmom.valid} function. Normally this should be left as the default and it is very unlikely that the L-moments will not be viable (particularly in the \eqn{\tau_4} and \eqn{\tau_3} inequality). However, for some circumstances or large simulation exercises then one might want to bypass this check.}
}

\value{
  An R \code{list} is returned.

  \item{type}{The type of distribution: \code{ln3}.}
  \item{para}{The parameters of the distribution.}
  \item{source}{The source of the parameters: \dQuote{parln3}.}
}
\references{
NEED
}
\author{ W.H. Asquith}
\seealso{\code{\link{lmom.ub}}, \code{\link{lmomln3}},
\code{\link{cdfln3}}, \code{\link{qualn3}}
}
\examples{
lmr <- lmom.ub(rnorm(20))
parln3(lmr)

\dontrun{
# Handling condition of negative L-skew
# Data reversal looks like: Y <- -X, but let us use an example
# on the L-moments themselves.
lmr.pos <- vec2lmom(c(100, 45, -0.1)) # parln3(lmr.pos) fails
lmr.neg <- lmr.pos
lmr.neg$lambdas[1] <- -lmr.neg$lambdas[1]
lmr.neg$ratios[3]  <- -lmr.neg$ratios[3]
F <- nonexceeds()
plot(F, -qualn3(1-F, parln3(lmr.neg)), type="l", lwd=3, col=2) # red line
lines(F, quagno(F, pargno(lmr.pos))) # black line
}
}
\keyword{distribution (parameters)}
