% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfree.R
\name{dfree}
\alias{dfree}
\title{Degrees of freedom for an object of class 'lmvar'}
\usage{
dfree(object, mu = TRUE, sigma = TRUE, ...)
}
\arguments{
\item{object}{Object of class 'lmvar'}

\item{mu}{Boolean, specifies whether the degrees of freedom for the model for the expectation values must be included.}

\item{sigma}{Boolean, specifies whether the degrees of freedom for the model for the standard deviations must be included.}

\item{...}{Additional arguments, not used in the current implementation}
}
\value{
An integer containing the degrees of freedom for the model in \code{object}.
}
\description{
Degrees of freedom for the model in an object of class 'lmvar'. The degrees of freedom are defined as the rank of the
model matrix \eqn{X_\mu} for the expectation values, plus the rank of the model matrix \eqn{X_\sigma} for the standard deviations.
}
\details{
If \code{mu = TRUE} and \code{sigma = TRUE}, the function returns the rank of the model-matrix \eqn{X_\mu} plus the
rank of the model matrix \eqn{X_\sigma}.

If \code{mu = TRUE} and \code{sigma = FALSE}, the function returns the rank of the model-matrix \eqn{X_\mu}.

If \code{mu = FALSE} and \code{sigma = TRUE}, the function returns the rank of the model-matrix \eqn{X_\sigma}.

Both model matrices contain a column corresponding to an intercept term. This column is added by \code{\link{lmvar}}.
See also the vignette 'Intro'.
}
\examples{
# As example we use the dataset 'attenu' from the library 'datasets'. The dataset contains
# the response variable 'accel' and two explanatory variables 'mag'  and 'dist'.
library(datasets)

# Create the model matrix for the expected values
X = cbind(attenu$mag, attenu$dist)
colnames(X) = c("mag", "dist")

# Create the model matrix for the standard deviations.
X_s = cbind(attenu$mag, 1 / attenu$dist)
colnames(X_s) = c("mag", "dist_inv")

# Carry out the fit
fit = lmvar(attenu$accel, X, X_s)

# The degrees of freedom are
dfree(fit)

# The degrees of freedom of the expected values are
dfree(fit, sigma = FALSE)

# The degrees of freedom of the standard deviations are
dfree(fit, mu = FALSE)
}
