% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_events.R
\name{hydro_events}
\alias{hydro_events}
\title{Splitting to hydrological events}
\usage{
hydro_events(dataframe, q, datetime, window = 1)
}
\arguments{
\item{dataframe}{A data set object}

\item{q}{Water discharge variable (or water stage)}

\item{datetime}{Datetime variable (column in POSIXct format)}

\item{window}{Indicate time period to search for a local minimum (in hours)}
}
\value{
A data frame with class \code{tbl_df} with a hydrological events
column \code{he}
added
}
\description{
This function demarcates hydrological events. Start and
endpoint of each event are identified by Local Minimum method (\emph{Sloto
and Crouse, 1996}) within the specified time window.
}
\examples{
data(djan)
output_table <- hydro_events(dataframe = djan, q = discharge, datetime = time, window = 21)
}
\references{
Sloto, R.A., Crouse, M.Y., 1996. Hysep: a computer program for
streamflow hydrograph separation and analysis, \emph{U.S. Geological Survey Water-Resources Investigations Report} 96-4040.
}
