% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParLin_expectreg_hetero.R
\name{ParLin_expectreg_hetero}
\alias{ParLin_expectreg_hetero}
\title{Partially linear expectile regression with different possible heteroscedastic error and
univariate variable in the nonparametric function}
\usage{
ParLin_expectreg_hetero(
  X,
  Y,
  Z,
  omega = 0.3,
  kernel = gaussK,
  heteroscedastic = c("X", "Z", "Z and X")
)
}
\arguments{
\item{X}{The covariates data values for the linear part
(of size \eqn{n \times k} with \code{k=1} or \code{k=2}).}

\item{Y}{The response data values.}

\item{Z}{The covariate data values for the nonparametric part.}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}

\item{heteroscedastic}{Heteroscedastic error depending on \code{X}, or on\code{Z}
or on \code{Z} and \code{X}}
}
\value{
\code{\link{ParLin_expectreg_hetero}} partially linear expectile estimators
for different heteroscedastic error structures and a univariare variable in the nonparametric part,
proposed and studied by Adam and Gijbels (2021b). \code{\link{ParLin_expectreg_hetero}}
returns a list whose components are:
\itemize{
\item If the heteroscedastic error depends on \eqn{Z}:
\itemize{
 \item \code{Linear} The delta estimators for the linear part
 \item \code{Nonlinear} The estimation of the nonparametric part
 according to the observed values \eqn{Z_i}.
}
\item If the heteroscedastic error depends on \eqn{X}:
\itemize{
 \item \code{Linear} The delta estimators for the linear part
 \item \code{Nonlinear_g} The estimation of the nonparametric part
 according to the observed values \eqn{Z_i}.
 \item \code{Nonlinear_g_omega} The estimation of
 the nonparametric part according to the observed values \eqn{X_i} (if \eqn{X} is univariate)
 or to the couple of observed values \eqn{(X_{1i},X_{2j})}.
}
\item If the heteroscedastic error depends on \eqn{Z} and \eqn{X}:
\itemize{
 \item \code{Linear} The delta estimators for the linear part
 \item \code{Nonlinear_g} The estimation of the nonparametric part
 according to the couple of the observed values \eqn{(Z_i,X_j)} (if \eqn{X} is univariate)
 or to the observed values \eqn{(Z_i,X_{1i},X_{2i})}.
}

}
}
\description{
Formula interface for the partially linear expectile regression
using local linear expectile estimation for different heteroscedastic error structure and
a univariate variable in the nonparametric function \eqn{g(.)}. The model is of the form
\eqn{Y=\delta^T X + g(Z) + \sigma(X) \epsilon}, \eqn{Y=\delta^T X + g(Z) + \sigma(Z) \epsilon}
or \eqn{Y=\delta^T X + g(Z) + \sigma(Z,X) \epsilon}.
See Table 1 in Adam and Gijbels (2021b) for more details.
}
\examples{
\donttest{
library(locpol)
set.seed(123)
Z<-runif(100,-3,3)
eta_1<-rnorm(100,0,1)
X1<-(0.9*Z)+(1.5*eta_1)
set.seed(1234)
eta_2<-rnorm(100,0,2)
X2<-(0.9*Z)+(1.5*eta_2)
X<-rbind(X1,X2)

set.seed(12345)
epsilon<-rnorm(100,0,1)
delta<-rbind(0.8,-0.8)

Y<-as.numeric((t(delta)\%*\%X)+(10*sin(0.9*Z))+(0.6*X1^2)*epsilon)

ParLin_expectreg_hetero(X=t(X),Y=Y,Z=Z,omega=0.3,kernel=gaussK,heteroscedastic="X")
}
}
\references{
{

Adam, C. and Gijbels, I. (2021b). Partially linear expectile regression using
local polynomial fitting. In Advances in Contemporary Statistics and Econometrics:
Festschrift in Honor of Christine Thomas-Agnan, Chapter 8, pages 139–160. Springer, New York.

}
}
