% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_GenROT.R
\name{h_GenROT}
\alias{h_GenROT}
\alias{compDerEst_exp}
\title{Rule-of-Thumb bandwidth selectors}
\usage{
h_GenROT(X, Y, j = 0, p = 1, kernel = gaussK, omega)

compDerEst_exp(X, Y, p, omega)
}
\arguments{
\item{X}{The covariate data values.}

\item{Y}{The response data values.}

\item{j}{The order of derivative to estimate. In default setting, \code{j=0}.}

\item{p}{The order of the local polynomial estimator. In default setting,
\code{p=1}.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}
}
\value{
\code{\link{h_GenROT}} provides the general Rule-of-Thumb bandwidth selector
for the expectile regression proposed by Adam and Gijbels (2021a).

\code{\link{compDerEst_exp}} returns a data frame whose
components are:
\itemize{
 \item \code{X} The covariate data values.
 \item \code{Y} The response data values.
 \item \code{fit} The fitted values for the parametric estimation
 (leading to the Rule-of-Thumb expression).
 \item \code{der} The derivative estimation at \eqn{X} values.
}
}
\description{
General Rule-of-Thumb bandwidth selector for univariate expectile regression
proposed by Adam and Gijbels (2021a) see Formula (24). The weight function \eqn{k_0(x)}
is chosen to be equal to the indicator function on \eqn{[min(X_i)+0.1,max(X_i)-0.1]}.
}
\examples{
library(locpol)
data(mcycle)
y=mcycle$accel
x=mcycle$times

h=h_GenROT(X=x,Y=y,j=0,p=1,kernel=gaussK,omega=0.1)
#h=1.887636

}
\references{
{

Adam, C. and Gijbels, I. (2021a). Local polynomial expectile regression.
Annals of the Institute of Statistical Mathematics doi:10.1007/s10463-021-00799-y.

}
}
