% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_logs}
\alias{read_logs}
\title{Return log file as an R data frame}
\usage{
read_logs(logfile, log_format = "ndjson")
}
\arguments{
\item{logfile}{Path to log file. Will default to currently-set log file.}

\item{log_format}{Format of log file. Defaults to "ndjson". Note that this
may never have another option in the future, but the code is written to
support it dynamically in the future, mostly as a placeholder to the
author.}
}
\value{
A \code{data.frame}.
}
\description{
This function returns a \code{data.frame} containing all the logs in the provided
\verb{ndjson`` log file. If no explicit log file is provided, calling this function will return a data frame of the log file currently pointed to by the }loggit` functions.
}
\examples{
  set_logfile(file.path(tempdir(), "loggit.json"), confirm = FALSE)
  message("Test log message")
  read_logs()

}
