% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logiBin.R
\name{naCombine}
\alias{naCombine}
\title{Combine NA bins}
\usage{
naCombine(binObj, xVars, cutoffPropn = 0.01)
}
\arguments{
\item{binObj}{- An object returned by getBins or other functions (except  createBins) in this package}

\item{xVars}{- A vector of names of variables for which NA bins have to be combined}

\item{cutoffPropn}{- The minimum proportion of observations that must be present in the NA bin for it to be combined with the bin with closest bad rate. If the proportion s below this, the NA bin will be combined with bin having average bad rate}
}
\value{
Returns a list containing 3 objects. Similar to the getBins function
}
\description{
This function combines the NA bin with either the bin having the closest bad rate or the average bad rate if the count of observations in NA bin is low
}
\examples{
b1 <- getBins(loanData, "bad_flag", c('age', 'score', 'LTV'), minCr=0.01)
b1 <- naCombine(b1, c('age','LTV'))

}
