% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datalists.R
\name{read_data}
\alias{read_data}
\title{Create the dataframe object used for the standard analysis model}
\usage{
read_data(
  data_path = NULL,
  custom_data = NULL,
  prompt_mapping = TRUE,
  language = "de"
)
}
\arguments{
\item{data_path}{a string indicating the path for an official Excel file,
if this parameter is set to \code{NULL}, the function reads the dataframe
object provided in the parameter \code{custom_data} instead}

\item{custom_data}{a dataframe which was imported by the user beforehand,
if this parameter is set to \code{NULL}, the function import the data from
the path provided in the parameter \code{data_path} instead}

\item{prompt_mapping}{a boolean indicating whether the function prompts the
user for the exact mapping of his dataframe or whether the columns are
mapped automatically by order. This parameter is only relevant when
\code{custom_data} is not set to \code{NULL}}

\item{language}{a character string representing the language in which the
columns will be displayed during the mapping prompt (\code{"de"} or
\code{"fr"} or \code{"it"} or \code{"en"}). This parameter is only relevant
when \code{custom_data} is not set to \code{NULL}}
}
\value{
a dataframe which can be used to compute the standard analysis model
}
\description{
Reads either a custom dataframe object or an official Excel file (datalist
or data export) and transforms it to a dataframe object which can be used
for the standard analysis model
}
\details{
Exactly one of \code{data_path} or \code{custom_data} must be \code{NULL}.
}
