% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predictProbs}
\alias{predictProbs}
\title{Predict expected choice probabilities}
\usage{
predictProbs(
  model,
  alts,
  altID,
  obsID = NULL,
  computeCI = TRUE,
  ci = 0.95,
  numDraws = 10^4,
  alpha
)
}
\arguments{
\item{model}{The output of a model estimated model using the \code{logitr()}
function.}

\item{alts}{A data frame of a set of alternatives for which to predict
choice probabilities. Each row is an alternative and each column an
attribute corresponding to parameter names in the estimated model.}

\item{altID}{The name of the column that identifies each alternative
in each set of alternatives.}

\item{obsID}{The name of the column that identifies each set of
alternatives. Required if predicting results for more than one set of
alternatives. Defaults to \code{NULL} (for a single set of alternatives).}

\item{computeCI}{Should a confidence interval be computed?
Defaults to \code{TRUE}.}

\item{ci}{The sensitivity of the computed confidence interval (CI).
Defaults to \code{ci = 0.95}, reflecting a 95\% CI.}

\item{numDraws}{The number of draws to use in simulating uncertainty
for the computed confidence interval.}

\item{alpha}{The sensitivity of the computed confidence interval.
No longer used as of v0.2.7 - if provided, a warning is shown and \code{ci}
is computed from \code{alpha}.}
}
\value{
A data frame with the estimated choice probabilities for each
alternative in \code{alts}.
}
\description{
Returns the expected choice probabilities for a single set or multiple sets
of alternatives based on the results from an estimated model.
}
\keyword{logitr}
\keyword{predict}
\keyword{probabilities}
\keyword{simulation}
