% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom.R
\name{augment.logitr}
\alias{augment.logitr}
\title{Glance a \code{logitr} class object}
\usage{
\method{augment}{logitr}(x, newdata = NULL, obsID = NULL, type = "prob", ...)
}
\arguments{
\item{x}{is an object of class \code{logitr}.}

\item{newdata}{a \code{data.frame}. Each row is an alternative and each column an
attribute corresponding to parameter names in the estimated model. Defaults
to \code{NULL}, in which case predictions are made on the original data used to
estimate the model.}

\item{obsID}{The name of the column that identifies each set of
alternatives in the data. Required if newdata != NULL. Defaults to \code{NULL},
in which case the value for \code{obsID} from the data in \code{object} is used.}

\item{type}{A character vector defining what to predict: \code{prob} for
probabilities, \code{outcomes} for outcomes. If you want both outputs, use
\code{c("prob", "outcome")}. Outcomes are predicted randomly according to the
predicted probabilities. Defaults to \code{"prob"}.}

\item{...}{further arguments.}
}
\value{
A tibble of ...
}
\description{
Glance a \code{logitr} class object
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Extract a tibble of the model summary statistics
augment(mnl_pref)

}
