% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.logitr}
\alias{confint.logitr}
\title{Extract Model Confidence Interval}
\usage{
\method{confint}{logitr}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{is an object of class \code{logitr} (a model estimated using
the 'logitr()` function).}

\item{parm}{A specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names.
If missing, all parameters are considered.}

\item{level}{The confidence level required.}

\item{...}{further arguments.}
}
\value{
A data frame of the confidence intervals of model coefficients.
}
\description{
Returns confidence intervals from an object of class \code{logitr}.
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Compute a confidence interval
confint(mnl_pref)
}
\keyword{confint}
\keyword{logitr}
