% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_plot.R
\name{l_plot}
\alias{l_plot}
\title{Create an interactive loon plot widget}
\usage{
l_plot(x, y, ...)
}
\arguments{
\item{x}{the coordinates of points in the plot. Alternatively, a
      single plotting structure, function or \emph{any \R object with a
        \code{plot} method} can be provided.}

\item{y}{the y coordinates of points in the plot, \emph{optional}
    if \code{x} is an appropriate structure.}

\item{...}{named arguments to modify plot states}
}
\value{
widget handle
}
\description{
\code{l_plot} is a generic function for creating interactive
  visualization environments for \R objects.
}
\details{
\ifelse{html}{
\out{<div style="background: #dff0d8; padding: 15px;"> To get started with loon it is recommended to read loons website
  which can be accessed via the <code>l_help()</code> function call. </div>
}}{
To get started with loon it is recommended to read loons website
  which can be accessed via the \code{l_help()} function call.
}


  \if{html}{ The general direct manipulation and interaction gestures are
  outlined in the following figures.

  Zooming and Panning

  \figure{gestures_zoom_pan.png}{options: alt="Zoom pan gestures"}

  Selecting Points/Objects

  \figure{gestures_select.png}{options: alt="Select gestures"}

  Moving Points on the Scatterplot Display

  \figure{gestures_move.png}{options: alt="Move gestures"}

  }
}
\examples{
# ordinary use
p <- with(iris, l_plot(Sepal.Width, Petal.Length, color=Species))

names(p)
p["glyph"]
p["size"] <- 10
p["color"] <- "grey"
p["color"] <- iris$Species
versi <- iris$Species == "versicolor"
p["glyph"][versi] <- "otriangle"
p["glyph"][versi] <- "ctriangle"

# link another plot with the previous plot
l_configure(p, linkingGroup = "iris_data", sync = "pull")
p2 <- with(iris, l_plot(Sepal.Length, Petal.Width,
                        linkingGroup="iris_data",
                        title = "Second plot",
                        showGuides = TRUE))
p2["showScales"] <- TRUE

# Get an R (grid) graphics plot of the current loon plot
plot(p)
# or with more control about grid parameters
grid.loon(p)
# or to save the grid data structure (grob) for later use
pg <- loonGrob(p)

# Use with other tk widgets
tt <- tktoplevel()
p1 <- l_plot(parent=tt, x=c(1,2,3), y=c(3,2,1))
p2 <- l_plot(parent=tt, x=c(4,3,1), y=c(6,8,4))

tkgrid(p1, row=0, column=0, sticky="nesw")
tkgrid(p2, row=0, column=1, sticky="nesw")
tkgrid.columnconfigure(tt, 0, weight=1)
tkgrid.columnconfigure(tt, 1, weight=1)
tkgrid.rowconfigure(tt, 0, weight=1)

tktitle(tt) <- "Loon plots with custom layout"
}
\seealso{
\code{\link{l_info_states}}
}
