% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_glyphs.R
\name{l_primitiveGlyphs}
\alias{l_primitiveGlyphs}
\title{The primitive glyphs available to a scatterplot or graph display}
\usage{
l_primitiveGlyphs()
}
\value{
A character vector of the names of all primitive glyphs in loon.
}
\description{
Returns a vector of the available primitive glyphs.
}
\details{
The scatterplot and graph displays both have the n-dimensional state
  \code{'glyph'} that assigns each data point or graph node a glyph (i.e. a
visual representation).

Loon distinguishes between primitive and non-primitive glyphs: the primitive
glyphs are always available for use whereas the non-primitive glyphs need to
be first specified and added to a plot before they can be used.

The primitive glyphs are:

\ifelse{html}{\figure{point_glyph_primitive_types.png}{options: alt="Primitive Glyphs"}}{
\tabular{l}{
  \code{'circle'}, \code{'ocircle'}, \code{'ccircle'}\cr
  \code{'square'}, \code{'osquare'}, \code{'csquare'}\cr
  \code{'triangle'}, \code{'otriangle'}, \code{'ctriangle'}\cr
  \code{'diamond'}, \code{'odiamond'}, \code{'cdiamond'}
}

Note that the letter \code{'o'} stands for outline only, and the letter
\code{'c'} stands for contrast and adds an outline with the
\code{'foreground'} color (black by default).
}

For more information run: \code{l_help("learn_R_display_plot.html#glyphs")}
}
\seealso{
Other glyph functions: \code{\link{l_glyph_add.default}},
  \code{\link{l_glyph_add_image}},
  \code{\link{l_glyph_add_pointrange}},
  \code{\link{l_glyph_add_polygon}},
  \code{\link{l_glyph_add_serialaxes}},
  \code{\link{l_glyph_add_text}},
  \code{\link{l_glyph_add}}, \code{\link{l_glyph_delete}},
  \code{\link{l_glyph_getLabel}},
  \code{\link{l_glyph_getType}}, \code{\link{l_glyph_ids}},
  \code{\link{l_glyph_relabel}}
}
\concept{glyph functions}
