% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_show}
\alias{l_layer_show}
\title{Show or unhide a Layer}
\usage{
l_layer_show(widget, layer)
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
0 if success otherwise the function throws an error
}
\description{
Hidden or invisible layers are not rendered. This function
  unhides invisible layer so that they are rendered again.
}
\details{
Visibile layers are rendered, invisible ones are not. If any
  ancestor of a layer is set to be invisible then the layer is not rendered
  either. The layer visibility flag can be checked with
  \code{\link{l_layer_isVisible}} and the actual visibility (i.e. are all the
  ancesters visibile too) can be checked with
  \code{\link{l_layer_layerVisibility}}.

  Note that layer visibility is not a state of the layer itself,
  instead is information that is part of the layer collection (i.e. its
  parent widget).
}
\examples{
if(interactive()){

p <- l_plot()

l <- l_layer_rectangle(p, x=0:1, y=0:1, color="steelblue")
l_layer_hide(p, l)

l_layer_show(p, l)

}
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_layer_hide}},
  \code{\link{l_layer_isVisible}}, \code{\link{l_layer_layerVisibility}},
  \code{\link{l_layer_groupVisibility}}
}
