% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_lines}
\alias{l_layer_lines}
\title{Layer lines}
\usage{
l_layer_lines(
  widget,
  x,
  y,
  color = "black",
  linewidth = 1,
  label = "lines",
  parent = "root",
  index = 0,
  group = NULL,
  active = TRUE,
  ...
)
}
\arguments{
\item{widget}{widget path name as a string}

\item{x}{list with vectors with x coordinates}

\item{y}{list with vectors with y coordinates}

\item{color}{color of lines}

\item{linewidth}{vector with line widths}

\item{label}{label used in the layers inspector}

\item{parent}{group layer}

\item{index}{of the newly added layer in its parent group}

\item{group}{separate x vector or y vector into a list by group.}

\item{active}{a logical determining whether objects appear or not
(default is \code{TRUE} for all).}

\item{...}{additional state initialization arguments, see
\code{\link{l_info_states}}}
}
\value{
layer object handle, layer id
}
\description{
Loon's displays that are based on Cartesian coordinates (i.e.
  scatterplot, histogram and graph display) allow for layering visual
  information including polygons, text and rectangles.
}
\details{
For more information run: \code{l_help("learn_R_layer")}
}
\examples{
if(interactive()){

s <- Filter(function(df)nrow(df) > 1, split(UsAndThem, UsAndThem$Country))
sUaT <- Map(function(country){country[order(country$Year),]} , s)
xcoords <- Map(function(x)x$Year, sUaT)
ycoords <- Map(function(x)x$LifeExpectancy, sUaT)
region <- sapply(sUaT, function(x)as.character(x$Geographic.Region[1]))

p <- l_plot(showItemLabels=TRUE)
l <- l_layer_lines(p, xcoords, ycoords, itemLabel=names(sUaT), color=region)
l_scaleto_layer(l)

# Set groups
p <- l_plot(showItemLabels=TRUE)
l <- l_layer_lines(p,
                   x = c((0:4)/10, rep(.5, 5), (10:6)/10, rep(.5, 5)),
                   y = c(rep(.5, 5), (10:6/10), rep(.5, 5), (0:4)/10),
                   group = rep(1:5, 4),
                   linewidth = 4,
                   col = l_getColorList()[1:5])
l_scaleto_layer(l)

}
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_info_states}}
}
