summary.lordif.MC <-
function(object, ...) {
cat("Call:\n")
print(object$call)
cat("\n")
cat(paste("  Number of iterations:",object$nr,"\n\n"))
print(object$cutoff)
qquantile<-function(x) quantile(x,probs=c(0,.01,.05,.1,.25,.5,.75,.9,.95,.99,1))
cat("\nselected quantiles - prob. associated with Chi-square (Model 1 vs. Model 2):\n\n")
print(apply(object$chi12,2,qquantile))
cat("\nselected quantiles - prob. associated with Chi-square (Model 1 vs. Model 3):\n\n")
print(apply(object$chi13,2,qquantile))
cat("\nselected quantiles - prob. associated with Chi-square (Model 2 vs. Model 3):\n\n")
print(apply(object$chi23,2,qquantile))
cat("\nselected quantiles - Cox & Snell pseudo R^2 (Model 1 vs. Model 2):\n\n")
print(apply(object$pseudo12.CoxSnell,2,qquantile))
cat("\nselected quantiles - Cox & Snell pseudo R^2 (Model 1 vs. Model 3):\n\n")
print(apply(object$pseudo13.CoxSnell,2,qquantile))
cat("\nselected quantiles - Cox & Snell pseudo R^2 (Model 2 vs. Model 3):\n\n")
print(apply(object$pseudo23.CoxSnell,2,qquantile))
cat("\nselected quantiles - Nagelkerke pseudo R^2 (Model 1 vs. Model 2):\n\n")
print(apply(object$pseudo12.Nagelkerke,2,qquantile))
cat("\nselected quantiles - Nagelkerke pseudo R^2 (Model 1 vs. Model 3):\n\n")
print(apply(object$pseudo13.Nagelkerke,2,qquantile))
cat("\nselected quantiles - Nagelkerke pseudo R^2 (Model 2 vs. Model 3):\n\n")
print(apply(object$pseudo23.Nagelkerke,2,qquantile))
cat("\nselected quantiles - McFadden pseudo R^2 (Model 1 vs. Model 2):\n\n")
print(apply(object$pseudo12.McFadden,2,qquantile))
cat("\nselected quantiles - McFadden pseudo R^2 (Model 1 vs. Model 3):\n\n")
print(apply(object$pseudo13.McFadden,2,qquantile))
cat("\nselected quantiles - McFadden pseudo R^2 (Model 2 vs. Model 3):\n\n")
print(apply(object$pseudo23.McFadden,2,qquantile))
cat("\nselected quantiles - proportionate Beta change (Model 1 vs. Model 2):\n\n")
print(apply(object$beta12,2,qquantile))
invisible(object)
}

