% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori_tools.R
\name{cv.lori}
\alias{cv.lori}
\title{cv.lori}
\usage{
cv.lori(Y, cov = NULL, N = 10, thresh = 1e-05, maxit = 100,
  rank.max = 5, trace.it = F, parallel = F, len = 20)
}
\arguments{
\item{Y}{[matrix, data.frame] abundance table (nxp)}

\item{cov}{[matrix, data.frame] design matris (npxq)}

\item{N}{[integer] number of cross-validation folds}

\item{thresh}{[positive number] convergence threshold, default is 1e-5}

\item{maxit}{[integer] maximum number of iterations, default is 100}

\item{rank.max}{[integer] maximum rank of interaction matrix, default is 2}

\item{trace.it}{[boolean] whether information about convergence should be printed}

\item{parallel}{[boolean] whether the N-fold cross-validation should be parallelized, default value is TRUE}

\item{len}{[integer] the size of the grid}
}
\value{
A list with the following elements
\item{lambda1}{regularization parameter estimated by cross-validation for nuclear norm penalty (interaction matrix)}
\item{lambda2}{regularization parameter estimated by cross-validation for l1 norm penalty (main effects)}
\item{errors}{a table containing the prediction errors for all pairs of parameters}
}
\description{
cv.lori
}
\examples{
X <- matrix(rnorm(50), 10)
Y <- matrix(rpois(10, 1:10), 5)
res <- cv.lori(Y, X, N=2, len=2)
}
