% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori.R
\name{lori}
\alias{lori}
\title{LORI method.}
\usage{
lori(Y, cov = NULL, lambda1 = NULL, lambda2 = NULL, reff = T,
  ceff = T, rank.max = 5, thresh = 1e-05, maxit = 1000,
  trace.it = F)
}
\arguments{
\item{Y}{[matrix, data.frame] count table (nxp).}

\item{cov}{[matrix, data.frame] design matrix (np*q) in order row1xcol1,row2xcol2,..,rownxcol1,row1xcol2,row2xcol2,...,...,rownxcolp}

\item{lambda1}{[positive number] the regularization parameter for the interaction matrix.}

\item{lambda2}{[positive number] the regularization parameter for the covariate effects.}

\item{reff}{[boolean] whether row effects should be fitted, default value is TRUE}

\item{ceff}{[boolean] whether column effects should be fitted, default value is TRUE}

\item{rank.max}{[integer] maximum rank of interaction matrix (smaller than min(n-1,p-1))}

\item{thresh}{[positive number] convergence tolerance of algorithm, by default \code{1e-6}.}

\item{maxit}{[integer] maximum allowed number of iterations.}

\item{trace.it}{[boolean] whether convergence information should be printed}
}
\value{
A list with the following elements
\item{X}{nxp matrix of log of expected counts}
\item{alpha}{row effects}
\item{beta}{column effects}
\item{epsilon}{covariate effects}
\item{theta}{nxp matrix of row-column interactions}
\item{imputed}{nxp matrix of imputed counts}
\item{means}{nxp matrix of expected counts (exp(X))}
\item{cov}{npxK matrix of covariates}
}
\description{
LORI method.
}
\examples{
\dontshow{
X <- matrix(rnorm(50), 25)
Y <- matrix(rpois(25, 1:25), 5)
res <- lori(Y, X, 10, 10)
}
}
