% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tslphom_joint.R
\name{tslphom_joint}
\alias{tslphom_joint}
\title{Implements the tslphom_joint algorithm}
\usage{
tslphom_joint(
  votes_election1,
  votes_election2,
  counts = FALSE,
  solver = "lp_solve"
)
}
\arguments{
\item{votes_election1}{data.frame (or matrix) of order IxJ with the counts to be initially
mapped to rows. When estimating vote transfer matrices, the votes gained by
the \emph{J} political options competing on election 1 (or origin) in the \emph{I}
territorial units considered.  The sum by rows of \code{votes_election1} and
\code{votes_election2} must coincide.}

\item{votes_election2}{data.frame (or matrix) of order IxK with the counts to be initially mapped
to columns. When estimating vote transfer matrices, the votes gained by
the \emph{K} political options competing on election 2 (or destination) in the \emph{I}
territorial units considered. In general, The sum by rows of \code{votes_election1} and
\code{votes_election2} must coincide.}

\item{counts}{A TRUE/FALSE value that indicates whether the problem is solved in integer values (counts),
in both iterations: zero (lphom) and final (including unit) solutions. If TRUE, the LP matrices
are approximated to the closest integer solution solving the corresponding Integer Linear Program.
Default, FALSE.}

\item{solver}{A character string indicating the linear programming solver to be used, only
\code{lp_solve} and \code{symphony} are allowed. By default, \code{lp_solve}.}
}
\value{
A list with the following components
\item{VTM.votes}{ A matrix of order JxK with the estimated cross-distribution of votes of elections 1 and 2.}
\item{HETe}{ The estimated heterogeneity index associated to the \code{VTM.votes} solution.}
\item{VTM12}{ The matrix of order JxK with the estimated row-standardized proportions of vote transitions from election 1 to election 2 associated to the \code{VTM.votes} solution.}
\item{VTM21}{ The matrix of order KxJ with the estimated row-standardized proportions of vote transitions from election 2 to election 1 associated to the \code{VTM.votes} solution.}
\item{VTM.votes.units}{ An array of order JxKxI with the estimated matrix of cross-distributions of votes of elections 1 and 2 attained for each unit after congruently adjusting the \strong{lphom_joint()} initial estimate.}
\item{EHet12}{ A matrix of order IxK measuring in each unit a distance to the homogeneity hypothesis. That is, the differences under the homogeneity hypothesis between the actual recorded results and the expected results in each territorial unit for each option of election two. The matrix Eik.}
\item{EHet21}{ A matrix of order IxJ measuring in each unit a distance to the homogeneity hypothesis. That is, the differences under the homogeneity hypothesis between the actual recorded results and the expected results in each territorial unit for each option of election one. The matrix Eij.}
\item{inputs}{ A list containing all the objects with the values used as arguments by the function.}
\item{solution_init}{ A list with the main outputs produced by \strong{lphom_joint()}.}
}
\description{
Estimates RxC vote transfer matrices (ecological contingency tables) with tslphom_joint
}
\examples{
x <- France2017P[, 1:8]
y <- France2017P[, 9:12]
y[,1] <- y[,1]  - (rowSums(y) - rowSums(x))
mt <- tslphom_joint(x, y)
mt$VTM.votes
mt$HETe
}
\references{
Pavia, JM and Romero, R (2021). Symmetry estimating RxC vote transfer matrices from aggregate data, mimeo.
}
\seealso{
\code{\link{tslphom}} \code{\link{lphom_dual}} \code{\link{tslphom_dual}} \code{\link{nslphom_dual}} \code{\link{lphom_joint}} \code{\link{nslphom_joint}}

Other linear programing ecological inference functions: 
\code{\link{lclphom}()},
\code{\link{lphom_dual}()},
\code{\link{lphom_joint}()},
\code{\link{lphom}()},
\code{\link{nslphom_dual}()},
\code{\link{nslphom_joint}()},
\code{\link{nslphom}()},
\code{\link{tslphom_dual}()},
\code{\link{tslphom}()}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}

Rafael Romero \email{rromero@eio.upv.es}
}
\concept{linear programing ecological inference functions}
