# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name get_vals_lagcrit
#' @title Compute values for lag length criteria
#' @description Compute values for 'AICc', 'AIC', or 'BIC'.
#'
#' @param y List with left (endogenous) variables.
#' @param x List with right (exogenous) variables.
#' @param lag_crit Integer: 'AICc'= 1, 'AIC' = 2, 'BIC' = 3.
#' @param h Integer.
#' @param k Integer.
#' @param max_lags Integer.
#' @references
#'
#' Akaike, H. (1974). "A new look at the statistical model identification", \emph{IEEE Transactions on Automatic Control}, 19 (6): 716–723.
NULL

#' Hurvich, C. M., and Tsai, C.-L. (1989). "Regression and time series model selection
#' in small samples", Biometrika, 76(2): 297–307,
#'
#' Schwarz, Gideon E. (1978). "Estimating the dimension of a model", \emph{Annals of Statistics}, 6 (2): 461–464.
#'
#' @keywords internal
get_vals_lagcrit <- function(y, x, lag_crit, h, k, max_lags, n_obs) {
    .Call(`_lpirfs_get_vals_lagcrit`, y, x, lag_crit, h, k, max_lags, n_obs)
}

#' @name hp_filter
#' @title Decompose a times series via the Hodrick-Prescott filter
#' @description  Estimate cyclical and trend component with filter by Hodrick and Prescott (1997).
#' The function is based on the function \emph{hpfilter} from the archived \emph{mFilter}-package.
#' @param x One column matrix with numeric values.
#' @param lambda Numeric value.
#' @return A list. The first element contains the cyclical component and the second element the trend component.
#' @examples
#' \donttest{
#' library(lpirfs)
#'
#'
#'# Decompose the Federal Funds Rate
#'  data_set     <- as.matrix(interest_rules_var_data$FF)
#'  hp_results   <- hp_filter(data_set, 1600)
#'
#'# Extract results and save as data.frame
#'  hp_cyc    <- as.data.frame(hp_results[[1]])
#'  hp_trend  <- as.data.frame(hp_results[[2]])
#'
#'# Make data.frames for plots
#'  cyc_df     <- data.frame(yy = hp_cyc$V1,   xx = seq(as.Date('1955-01-01'),
#'                             as.Date('2003-01-01') , "quarter"))
#'  trend_df   <- data.frame(yy = hp_trend$V1, xx = seq(as.Date('1955-01-01'),
#'                             as.Date('2003-01-01') , "quarter"))
#'
#'# Make plots
#'  library(ggplot2)
#'
#'# Plot cyclical part
#'  ggplot(data = cyc_df) +
#'  geom_line(aes(y = yy, x = xx))
#'
#'# Plot trend component
#'  ggplot(trend_df) +
#'  geom_line(aes(y = yy, x = xx))
#'
#'}
#' @references
#' Hodrick, R.J., and Prescott, E. C. (1997). "Postwar U.S. Business Cycles: An Empirical Investigation."
#' \emph{Journal of Money, Credit and Banking}, 29(1), 1-16.
#'
#' Ravn, M.O., Uhlig, H. (2002). "On Adjusting the Hodrick-Prescott Filter for the Frequency of Observations."
#' \emph{Review of Economics and Statistics}, 84(2), 371-376.
#' @author Philipp Adämmer
hp_filter <- function(x, lambda) {
    .Call(`_lpirfs_hp_filter`, x, lambda)
}

#' @name newey_west
#' @title Compute OLS parameters and robust standard errors based on Newey-West estimator
#' @description  Compute OLS parameters and robust standard errors based on Newey and West (1987).
#' The function is based on the Matlab code by James P. LeSage.
#' @param y Numeric vector.
#' @param x Numeric matrix.
#' @param h Integer.
#' @return A list. The first element contains the estimated OLS parameters and the second element
#' the covariance matrix of the parameters.
#' @keywords internal
#' @references
#' Newey, W.K., and West, K.D. (1987). “A Simple, Positive-Definite, Heteroskedasticity and
#' Autocorrelation Consistent Covariance Matrix.” \emph{Econometrica}, 55, 703–708.
newey_west <- function(y, x, h) {
    .Call(`_lpirfs_newey_west`, y, x, h)
}

#' @name newey_west_tsls
#' @title Compute 2SLS parameters and robust standard errors based on Newey-West
#' @description  Compute 2SLS parameters and robust standard errors based on Newey and West (1987).
#' Part of the function is based on the Matlab code by James P. LeSage.
#' @param y Numeric vector.
#' @param x Numeric matrix.
#' @param z Numeric matrix.
#' @param h Integer.
#' @return A list. The first element contains the estimated 2SLS parameters and the second element
#' the covariance matrix of these parameters.
#' @keywords internal
#' @references
#' Newey, W.K., and West, K.D. (1987). “A Simple, Positive-Definite, Heteroskedasticity and
#' Autocorrelation Consistent Covariance Matrix.” \emph{Econometrica}, 55, 703–708.
#' Wooldridge, J.M. (2002), Econometric Analysis of Cross Section and Panel Data, The MIT Press.
newey_west_tsls <- function(y, x, z, h) {
    .Call(`_lpirfs_newey_west_tsls`, y, x, z, h)
}

