# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name get_vals_lagcrit
#' @title Compute values for lag length criteria
#' @description Compute values for 'AICc', 'AIC', or 'BIC'.
#'
#' @param y List with left (endogenous) variables.
#' @param x List with right (exogenous) variables.
#' @param lag_crit Integer: 'AICc'= 1, 'AIC' = 2, 'BIC' = 3.
#' @param h Integer.
#' @param k Integer.
#' @param max_lags Integer.
#' @references
#'
#' Akaike, H. (1974). "A new look at the statistical model identification", \emph{IEEE Transactions on Automatic Control}, 19 (6): 716–723.
NULL

#' Hurvich, C. M., and Tsai, C.-L. (1989). "Regression and time series model selection
#' in small samples", Biometrika, 76(2): 297–307,
#'
#' Schwarz, Gideon E. (1978). "Estimating the dimension of a model", \emph{Annals of Statistics}, 6 (2): 461–464.
#'
#' @keywords internal
get_vals_lagcrit <- function(y, x, lag_crit, h, k, max_lags, n_obs) {
    .Call(`_lpirfs_get_vals_lagcrit`, y, x, lag_crit, h, k, max_lags, n_obs)
}

#' @name hp_filter
#' @title Decompose a times series via the Hodrick-Prescott filter
#' @description  Estimate cyclical and trend component with filter by Hodrick and Prescott (1997).
#' The function is based on the function \emph{hpfilter} from the archived \emph{mFilter}-package.
#' @param x One column matrix with numeric values.
#' @param lambda Numeric value.
#' @return A list. The first element contains the cyclical component and the second element the trend component.
#' @examples
#' \donttest{
#' library(lpirfs)
#'
#'
#'# Decompose the Federal Funds Rate
#'  data_set     <- as.matrix(interest_rules_var_data$FF)
#'  hp_results   <- hp_filter(data_set, 1600)
#'
#'# Extract results and save as data.frame
#'  hp_cyc    <- as.data.frame(hp_results[[1]])
#'  hp_trend  <- as.data.frame(hp_results[[2]])
#'
#'# Make data.frames for plots
#'  cyc_df     <- data.frame(yy = hp_cyc$V1,   xx = seq(as.Date('1955-01-01'),
#'                             as.Date('2003-01-01') , "quarter"))
#'  trend_df   <- data.frame(yy = hp_trend$V1, xx = seq(as.Date('1955-01-01'),
#'                             as.Date('2003-01-01') , "quarter"))
#'
#'# Make plots
#'  library(ggplot2)
#'
#'# Plot cyclical part
#'  ggplot(data = cyc_df) +
#'  geom_line(aes(y = yy, x = xx))
#'
#'# Plot trend component
#'  ggplot(trend_df) +
#'  geom_line(aes(y = yy, x = xx))
#'
#'}
#' @references
#' Hodrick, R.J., and Prescott, E. C. (1997). "Postwar U.S. Business Cycles: An Empirical Investigation."
#' \emph{Journal of Money, Credit and Banking}, 29(1), 1-16.
#'
#' Ravn, M.O., Uhlig, H. (2002). "On Adjusting the Hodrick-Prescott Filter for the Frequency of Observations."
#' \emph{Review of Economics and Statistics}, 84(2), 371-376.
#' @author Philipp Adämmer
hp_filter <- function(x, lambda) {
    .Call(`_lpirfs_hp_filter`, x, lambda)
}

#' @name newey_west
#' @title Compute OLS parameters and robust standard errors based on Newey-West estimator
#' @description  Compute OLS parameters and robust standard errors based on Newey and West (1987).
#' The function is based on the Matlab code by James P. LeSage.
#' @param y Numeric vector.
#' @param x Numeric matrix.
#' @param h Integer.
#' @return A list. The first element contains the estimated OLS parameters, the second element
#' the Newey West covariance matrix, the third element the estimated functions, the fourth element
#' the unscaled covariance matrix and the last element the meat estimator.
#' @keywords internal
#' @references
#' Newey, W.K., and West, K.D. (1987). “A Simple, Positive-Definite, Heteroskedasticity and
#' Autocorrelation Consistent Covariance Matrix.” \emph{Econometrica}, 55, 703–708.
newey_west <- function(y, x, h) {
    .Call(`_lpirfs_newey_west`, y, x, h)
}

#' @name newey_west_pw
#' @title Compute Newey-West estimator with prewhitened estimation functions
#' @description  Compute Newey-West estimator with prewhitened estimation functions.
#' The function is based on the Matlab code by James P. LeSage.
#' @param hhat_mat Matrix.
#' @param xpxi_mat Matrix.
#' @param D_mat Matrix.
#' @param h integer.
#' @return A list. The first element contains the pre-whitened Newey West covariance matrix.
#' @keywords internal
#' @references
#'
#' Andrews, D.W. and Monahan, J.C. (1992). An improved heteroskedasticity and
#' autocorrelation consistent covariance matrix estimator. \emph{Econometrica}, pp.953-966.
#'
#' Newey, W.K., and West, K.D. (1987). “A Simple, Positive-Definite, Heteroskedasticity and
#' Autocorrelation Consistent Covariance Matrix.” \emph{Econometrica}, 55, 703–708.
#'
#'
newey_west_pw <- function(hhat_mat, xpxi_mat, D_mat, h) {
    .Call(`_lpirfs_newey_west_pw`, hhat_mat, xpxi_mat, D_mat, h)
}

#' @name newey_west_tsls
#' @title Compute 2SLS parameters and robust standard errors based on Newey-West
#' @description  Compute 2SLS parameters and robust standard errors based on Newey and West (1987).
#' Part of the function is based on the Matlab code by James P. LeSage.
#' @param y Numeric vector.
#' @param x Numeric matrix.
#' @param z Numeric matrix.
#' @param h Integer.
#' @return A list. The first element contains the estimated 2SLS parameters and the second element
#' the 2SLS-Newey-West covariance matrix of these parameters.  The third element contains the estimated functions, the fourth element
#' the unscaled covariance matrix, the fifth element the meat estimator and the last element the ordinary covariance matrix of the
#' point estimates.
#' @keywords internal
#' @references
#' Newey, W.K., and West, K.D. (1987). “A Simple, Positive-Definite, Heteroskedasticity and
#' Autocorrelation Consistent Covariance Matrix.” \emph{Econometrica}, 55, 703–708.
#' Wooldridge, J.M. (2002), Econometric Analysis of Cross Section and Panel Data, The MIT Press.
newey_west_tsls <- function(y, x, z, h) {
    .Call(`_lpirfs_newey_west_tsls`, y, x, z, h)
}

#' @name ols_diagnost
#' @title Compute diagnostics for OLS models
#' @description  Compute OLS diagnostics such as R^2, adjusted R^2, AIC, etc.
#' @param y Numeric vector.
#' @param x Numeric matrix.
#' @return A list:
#'
#'\item{beta}{Point estimates of OLS regression.}
#'
#'\item{beta_cov}{Covariance matrix of point estimates.}
#'
#'\item{R^2}{The R^2 statistic from OLS regression. }
#'
#'\item{Adj.R^2}{The adjusted R^2 staistic from OLS regression.}
#'
#'\item{F-stat}{The computed F-statistic.}
#'
#'\item{df1}{First degress of freedom for F-statistic.}
#'
#'\item{df2}{Second degrees of freedom for F-staitisc.}
#'
#'\item{AIC_c}{The AIC_c criterion by Hurvich and Tsai (1989)}
#'
#'\item{AIC}{The AIC criterion by Akaike (1974)}
#'
#'\item{BIC}{The BIC criterion by Schwarz and Gideon (1978)}
#'
#' @keywords internal
#' @references
#' Akaike, H. (1974). "A new look at the statistical model identification", \emph{IEEE Transactions on Automatic Control}, 19 (6): 716–723.
#'
#' Hurvich, C. M., and Tsai, C.-L. (1989). "Regression and time series model selection
#' in small samples", Biometrika, 76(2): 297–307,
#'
#' Schwarz, G.(1978). "Estimating the dimension of a model", \emph{Annals of Statistics}, 6 (2): 461–464.
ols_diagnost <- function(y, x) {
    .Call(`_lpirfs_ols_diagnost`, y, x)
}

#' @name var_one
#' @title Compute VAR to prewhite estimating functions for Newey West estimator.
#' @description  Compute Newey-West estimator with prewhitened estimation functions.
#' @param VAR_Data Matrix.
#' @return A list. The first element contains the slope parameters of the VAR(1), the sedond element contains
#' the residuals and the third element the inverted slope parameter matrix.
#' @keywords internal
#' @references
#'
#' Andrews, D.W. and Monahan, J.C. (1992). An improved heteroskedasticity and
#' autocorrelation consistent covariance matrix estimator. \emph{Econometrica}, pp.953-966.
#'
#' Newey, W.K., and West, K.D. (1987). “A Simple, Positive-Definite, Heteroskedasticity and
#' Autocorrelation Consistent Covariance Matrix.” \emph{Econometrica}, 55, 703–708.
#'
#'
var_one <- function(VAR_Data) {
    .Call(`_lpirfs_var_one`, VAR_Data)
}

