% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPJmLMetaData.R
\name{LPJmLMetaData}
\alias{LPJmLMetaData}
\title{LPJmL meta data class}
\description{
A meta data container for LPJmL input and output meta data.
Container - because an \code{\link{LPJmLMetaData}} object is an environment in which
the meta data are stored after \code{\link[=read_meta]{read_meta()}} (or \code{\link[=read_io]{read_io()}}).
Each attribute can be accessed via \verb{$<attribute>}. To get an overview over
available attributes, \code{\link{print}} the object or export it as a list
\code{\link[=as_list]{as_list()}}.
The enclosing environment is locked and cannot be altered.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{sim_name}}{Simulation name (works as identifier in LPJmL Runner).}

\item{\code{source}}{LPJmL version (character string).}

\item{\code{history}}{Character string of the call used to run LPJmL. This
normally includes the path to the LPJmL executable and the path to the
configuration file for the simulation.}

\item{\code{variable}}{Name of the input/output variable, e.g. \code{"npp"} or
\code{"runoff"}.}

\item{\code{descr}}{Description of the input/output variable.}

\item{\code{unit}}{Unit of the input/output variable.}

\item{\code{nbands}}{Number (numeric) of bands (categoric dimension). Please
note that \code{nbands} follows the convention in LPJmL, which uses the
plural form for bands as opposed to \code{nyear} or \code{ncell}.}

\item{\code{band_names}}{Name of the bands (categoric dimension). Not included
if \code{nbands = 1}.}

\item{\code{nyear}}{Number (numeric) of data years in the parent \code{LPJmLData}
object.}

\item{\code{firstyear}}{First calendar year (numeric) in the parent \code{LPJmLData}
object.}

\item{\code{lastyear}}{Last calendar year (numeric) in the parent \code{LPJmLData}
object.}

\item{\code{nstep}}{Number (numeric) of intra-annual time steps. \code{1} for annual,
\code{12} for monthly, and \code{365} for daily data.}

\item{\code{timestep}}{Number (numeric) of years between time steps.
\code{timestep = 5} means that output is written every 5 years.}

\item{\code{ncell}}{Number (numeric) of cells in the parent \code{LPJmLData} object.}

\item{\code{firstcell}}{First cell (numeric) in the parent \code{LPJmLData} object.}

\item{\code{cellsize_lon}}{Longitude cellsize in degrees (numeric).}

\item{\code{cellsize_lat}}{Latitude cellsize in degrees (numeric).}

\item{\code{datatype}}{File data type (character string), e.g. \code{"float"}. Note
that data are converted into R-internal data type by \code{\link[=read_io]{read_io()}}.}

\item{\code{scalar}}{Conversion factor (numeric) applied when reading raw data
from file. The parent \code{LPJmLData} object contains the values after
the application of the conversion factor.}

\item{\code{order}}{Order of the data items in the file, either \code{"cellyear"},
\code{"yearcell"}, \code{"cellindex"}, or \code{"cellseq"}. The structure of the data
array in the parent \code{LPJmLData} object may differ from the original
order in the file depending on the \code{dim_order} parameter used in
\code{\link[=read_io]{read_io()}}.}

\item{\code{offset}}{Offset (numeric) at the start of the binary file before the
actual data start.}

\item{\code{bigendian}}{(Logical) Endianness refers to the order in which bytes
are stored in a multi-byte value, with big-endian storing the most
significant byte at the lowest address and little-endian storing the
least significant byte at the lowest address.}

\item{\code{format}}{Binary format (character string) of the file containing the
actual data. Either \code{"raw"}, \code{"clm"} (raw with header), or \code{"cdf"} for
NetCDF format.}

\item{\code{filename}}{Name of the file containing the actual data.}

\item{\code{subset}}{Logical. Whether parent \code{LPJmLData} object is subsetted.}

\item{\code{map}}{Character vector describing how to map the bands in an input
file to the bands used inside LPJmL. May be used by \code{\link[=read_io]{read_io()}} to
construct a \code{band_names} attribute.}

\item{\code{version}}{Version of data file.}

\item{\code{._data_dir_}}{\emph{Internal} character string containing the directory
from which the file was loaded.}

\item{\code{._subset_space_}}{\emph{Internal} logical. Whether space dimensions are
subsetted in the parent \code{LPJmLData} object.}

\item{\code{._fields_set_}}{\emph{Internal} character vector of names of attributes
set by the meta file.}

\item{\code{._time_format_}}{\emph{Internal} character string describing the time
dimension format, either \code{"time"} or \code{"year_month_day"}.}

\item{\code{._space_format_}}{\emph{Internal} character string describing the space
dimension format, either \code{"cell"} or \code{"lon_lat"}.}

\item{\code{._dimension_map_}}{\emph{Internal} dictionary/list of space and time
dimension formats with categories and namings.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LPJmLMetaData-as_list}{\code{LPJmLMetaData$as_list()}}
\item \href{#method-LPJmLMetaData-as_header}{\code{LPJmLMetaData$as_header()}}
\item \href{#method-LPJmLMetaData-print}{\code{LPJmLMetaData$print()}}
\item \href{#method-LPJmLMetaData-.__init_grid__}{\code{LPJmLMetaData$.__init_grid__()}}
\item \href{#method-LPJmLMetaData-.__update_subset__}{\code{LPJmLMetaData$.__update_subset__()}}
\item \href{#method-LPJmLMetaData-.__transform_time_format__}{\code{LPJmLMetaData$.__transform_time_format__()}}
\item \href{#method-LPJmLMetaData-.__transform_space_format__}{\code{LPJmLMetaData$.__transform_space_format__()}}
\item \href{#method-LPJmLMetaData-.__set_attribute__}{\code{LPJmLMetaData$.__set_attribute__()}}
\item \href{#method-LPJmLMetaData-new}{\code{LPJmLMetaData$new()}}
\item \href{#method-LPJmLMetaData-clone}{\code{LPJmLMetaData$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-as_list"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-as_list}{}}}
\subsection{Method \code{as_list()}}{
Method to coerce (convert) an \code{LPJmLMetaData} object into a
\link[base]{list}. \cr
See also \code{\link[=as_list]{as_list()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$as_list()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-as_header"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-as_header}{}}}
\subsection{Method \code{as_header()}}{
Method to coerce (convert) an \code{LPJmLMetaData} object into an LPJmL
binary file header. More information about file headers at
\code{\link[=create_header]{create_header()}}). \cr
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$as_header(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See \code{\link[=as_header]{as_header()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-print"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-print}{}}}
\subsection{Method \code{print()}}{
Method to print an \code{LPJmLMetaData} object.
See also \link[base]{print}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$print(all = TRUE, spaces = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{all}}{Logical. Should all attributes be printed or only the most
relevant (\code{all = FALSE})?}

\item{\code{spaces}}{\emph{Internal parameter} Spaces to be printed at the start.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-.__init_grid__"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-.__init_grid__}{}}}
\subsection{Method \code{.__init_grid__()}}{
!Internal method only to be used for package development!
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$.__init_grid__()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-.__update_subset__"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-.__update_subset__}{}}}
\subsection{Method \code{.__update_subset__()}}{
!Internal method only to be used for package development!
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$.__update_subset__(
  subset,
  cell_dimnames = NULL,
  time_dimnames = NULL,
  year_dimnames = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subset}}{List of subset arguments, see also \code{\link[=subset.LPJmLData]{subset.LPJmLData()}}.}

\item{\code{cell_dimnames}}{Optional list of new cell_dimnames of subset data
to update meta data. Required if spatial dimensions are subsetted.}

\item{\code{time_dimnames}}{Optional list of new time_dimnames of subset data
to update meta data. Required if time dimension is subsetted.}

\item{\code{year_dimnames}}{Optional list of new year_dimnames of subset data
to update meta data. Required if year dimension is subsetted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-.__transform_time_format__"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-.__transform_time_format__}{}}}
\subsection{Method \code{.__transform_time_format__()}}{
!Internal method only to be used for package development!
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$.__transform_time_format__(time_format)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{time_format}}{Character. Choose between \code{"year_month_day"} and
\code{"time"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-.__transform_space_format__"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-.__transform_space_format__}{}}}
\subsection{Method \code{.__transform_space_format__()}}{
!Internal method only to be used for package development!
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$.__transform_space_format__(space_format)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{space_format}}{Character. Choose between \code{"lon_lat"} and \code{"cell"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-.__set_attribute__"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-.__set_attribute__}{}}}
\subsection{Method \code{.__set_attribute__()}}{
!Internal method only to be used for package development!
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$.__set_attribute__(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Name of the attribute, e.g. \code{"variable"}}

\item{\code{value}}{Value of the attribute, e.g. \code{"grid"}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-new"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-new}{}}}
\subsection{Method \code{new()}}{
Create a new LPJmLMetaData object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$new(x, additional_attributes = list(), data_dir = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A list (not nested) with meta data.}

\item{\code{additional_attributes}}{A list of additional attributes to be set
that are not included in file header or JSON meta file. These are
\verb{c"(band_names", "variable", "descr", "unit")}}

\item{\code{data_dir}}{Directory containing the file this LPJmLMetaData object
refers to. Used to "lazy load" grid.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LPJmLMetaData-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LPJmLMetaData-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LPJmLMetaData$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
