% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getDesign}
\alias{getDesign}
\title{Get group sequential design}
\usage{
getDesign(
  beta = 0.2,
  drift = NA_real_,
  kMax = 1L,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  futilityStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  futilityBounds = NA_real_,
  typeBetaSpending = "none",
  parameterBetaSpending = NA_real_,
  userBetaSpending = NA_real_,
  spendingTime = NA_real_
)
}
\arguments{
\item{beta}{Type II error. Defaults to 0.2.}

\item{drift}{Drift parameter, i.e., \code{(theta-theta0)*sqrt(Imax)}.
If \code{drift} is provided, then the input \code{beta} will be ignored 
and power will be calculated.}

\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates in terms of number of events.
Fixed prior to the trial. Defaults to \code{(1:kMax) / kMax} if left
unspecified.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{futilityStopping}{Indicators of whether futility stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., \code{kMax-1}. Defaults to
\code{rep(-6, kMax-1)} if left unspecified.}

\item{typeBetaSpending}{The type of beta spending. One of the following:
"sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock type
spending function, "sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, "user" for
user defined spending, and "none" for no early futility stopping.
Defaults to "none".}

\item{parameterBetaSpending}{The parameter value for the beta spending.
Corresponds to rho for "sfKD", and gamma for "sfHSD".}

\item{userBetaSpending}{The user defined beta spending. Cumulative beta
spent up to each stage.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending 
time at each analysis. Defaults to missing, in which case, it is the 
same as \code{informationRates}.}
}
\value{
A list of S3 class \code{design} with three components:

* \code{overallResults} containing the overall rejection probability,
overall significance level, number of stages, drift parameter, 
and inflation factor (relative to fixed design).

* \code{byStageResults} containing information rates, efficacy
and futility boundaries on the Z-scale, probability for efficacy
and futility stopping at the stage, cumulative probability for
efficacy and futility stopping by the stage, cumulative alpha spent,
efficacy and futility boundaries on the p-value scale, 
and whether efficacy and futility stopping are allowed by stage.

* \code{settings} containing input parameters such as
alpha and beta spending function and parameter values, spendingTime, 
and calculation target.
}
\description{
Obtains the drift parameter and stopping boundaries for a
generic group sequential design assuming a constant treatment effect, 
or obtains the power given the drift parameter and stopping boundaries.
}
\examples{

# Example 1: obtain the drift parameter given power
getDesign(beta = 0.2,
          kMax = 2,
          informationRates = c(0.5,1),
          alpha = 0.025,
          typeAlphaSpending = "sfOF",
          typeBetaSpending = "sfP")
          

# Example 2: obtain power given the drift parameter
getDesign(drift = 3.026,
          kMax = 3,
          informationRates = c(0.5, 0.75, 1),
          alpha = 0.025,
          typeAlphaSpending = "sfOF",
          typeBetaSpending = "sfP")

}
