% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrsamplesize}
\alias{lrsamplesize}
\title{Log-rank test sample size}
\usage{
lrsamplesize(
  beta = 0.2,
  kMax = NA_integer_,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  futilityStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  futilityBounds = NA_real_,
  typeBetaSpending = "none",
  parameterBetaSpending = NA_real_,
  userBetaSpending = NA_real_,
  hazardRatioH0 = 1,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = 20L,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = 0.0309,
  lambda2 = 0.0533,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = 18,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  numSubintervals = 300L,
  estimateHazardRatio = 1L,
  typeOfComputation = "direct",
  interval = as.numeric(c(0.001, 240)),
  spendingTime = NA_real_
)
}
\arguments{
\item{beta}{Type II error. Defaults to 0.2.}

\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates in terms of number of events.
Fixed prior to the trial. Defaults to \code{(1:kMax) / kMax} if left
unspecified.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{futilityStopping}{Indicators of whether futility stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., \code{kMax-1}. Defaults to
\code{rep(-6, kMax-1)} if left unspecified.}

\item{typeBetaSpending}{The type of beta spending. One of the following:
"sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock type
spending function, "sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, "user" for
user defined spending, and "none" for no early futility stopping.
Defaults to "none".}

\item{parameterBetaSpending}{The parameter value for the beta spending.
Corresponds to rho for "sfKD", and gamma for "sfHSD".}

\item{userBetaSpending}{The user defined beta spending. Cumulative beta
spent up to each stage.}

\item{hazardRatioH0}{Hazard ratio under the null hypothesis for the active
treatment versus control. Defaults to 1 for superiority test.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{Accrual time intervals, must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities, one for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for
the piecewise exponential survival distribution, must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{First parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{Second parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{numSubintervals}{Number of sub-intervals to approximate the mean
and variance of the weighted log-rank test score statistic.
Defaults to 300. Specify a larger number for better approximation.}

\item{estimateHazardRatio}{Whether to estimate the hazard ratio from 
weighted Cox regression model and report the stopping boundaries on 
the hazard ratio scale.}

\item{typeOfComputation}{Whether to use the direct approximation method 
or the Schoenfeld method. Defaults to "direct". Can use "Schoenfeld" 
under proportional hazards and conventional log-rank test.}

\item{interval}{The interval to search for the solution of
accrualDuration or followupDuration. Defaults to \code{c(0.001, 240)}.
Adjustment may be needed for non-monotone relationship with study power.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending 
time at each analysis. Defaults to missing, in which case, it is the 
same as \code{informationRates}.}
}
\value{
A list of S3 class \code{lrpower}.
}
\description{
Obtains the needed accrual duration given power and
follow-up time, the needed follow-up time given power and
accrual duration, or the needed absolute accrual rates given
power, accrual duration, follow-up duration, and relative accrual
rates in a two-group survival design.
}
\examples{
# Piecewise accrual, piecewise exponential survivals, and 5\% dropout by
# the end of 1 year.

# Example 1: Obtains accrual duration given power and follow-up duration

lrsamplesize(beta = 0.2, kMax = 2,
             informationRates = c(0.8, 1),
             alpha = 0.025, typeAlphaSpending = "sfOF",
             accrualTime = seq(0, 9),
             accrualIntensity = c(26/9*seq(1, 9), 26),
             piecewiseSurvivalTime = c(0, 6),
             stratumFraction = c(0.2, 0.8),
             lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
             lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
             gamma1 = -log(1-0.05)/12,
             gamma2 = -log(1-0.05)/12,
             accrualDuration = NA,
             followupTime = 18, fixedFollowup = FALSE)


# Example 2: Obtains follow-up duration given power and accrual duration

lrsamplesize(beta = 0.2, kMax = 2,
             informationRates = c(0.8, 1),
             alpha = 0.025, typeAlphaSpending = "sfOF",
             accrualTime = seq(0, 9),
             accrualIntensity = c(26/9*seq(1, 9), 26),
             piecewiseSurvivalTime = c(0, 6),
             stratumFraction = c(0.2, 0.8),
             lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
             lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
             gamma1 = -log(1-0.05)/12,
             gamma2 = -log(1-0.05)/12,
             accrualDuration = 22,
             followupTime = NA, fixedFollowup = FALSE)


# Example 3: Obtains absolute accrual intensity given power,
# accrual duration, follow-up duration, and relative accrual intensity

lrsamplesize(beta = 0.2, kMax = 2,
             informationRates = c(0.8, 1),
             alpha = 0.025, typeAlphaSpending = "sfOF",
             accrualTime = seq(0, 9),
             accrualIntensity = c(26/9*seq(1, 9), 26),
             piecewiseSurvivalTime = c(0, 6),
             stratumFraction = c(0.2, 0.8),
             lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
             lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
             gamma1 = -log(1-0.05)/12,
             gamma2 = -log(1-0.05)/12,
             accrualDuration = 22,
             followupTime = 18, fixedFollowup = FALSE)
             

# Example 4: Non-inferiority trial with fixed follow-up and 
# superiority alternative

lrsamplesize(beta = 0.1, 
             kMax = 3, 
             alpha = 0.025,
             typeAlphaSpending = "sfOF",
             hazardRatioH0 = 1.1,
             accrualTime = c(0, 6),
             accrualIntensity = c(1000, 1500),
             lambda1 = log(2)/48*0.95,
             lambda2 = log(2)/48,
             gamma1 = -log(1-0.08)/12,
             gamma2 = -log(1-0.08)/12,
             accrualDuration = NA,
             followupTime = 18,
             fixedFollowup = 1, 
             typeOfComputation = "Schoenfeld")
                   


}
