% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrtest}
\alias{lrtest}
\title{Log-rank test of survival curve difference}
\usage{
lrtest(
  data,
  rep = "rep",
  stratum = "stratum",
  treat = "treat",
  time = "time",
  event = "event",
  rho1 = 0,
  rho2 = 0
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{rep}: The replication for by-group processing.
\item \code{stratum}: The stratum.
\item \code{treat}: The treatment.
\item \code{time}: The possibly right-censored survival time.
\item \code{event}: The event indicator.
}}

\item{rep}{The name of the replication variable in the input data.}

\item{stratum}{The name of the stratum variable in the input data.}

\item{treat}{The name of the treatment variable in the input data.}

\item{time}{The name of the time variable in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{rho1}{The first parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{The second parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{rep}: The replication.
\item \code{uscore}: The numerator of the log-rank test statistic.
\item \code{vscore}: The variance of the log-rank score test statistic.
\item \code{logRankZ}: The Z-statistic value.
\item \code{logRankPValue}: The one-sided p-value.
\item \code{rho1}: The first parameter of the Fleming-Harrington weights.
\item \code{rho2}: The second parameter of the Fleming-Harrington weights.
}
}
\description{
Obtains the log-rank test using the Fleming-Harrington
family of weights.
}
\examples{

df <- lrtest(data = rawdata, rep = "iterationNumber",
             stratum = "stratum", treat = "treatmentGroup",
             time = "timeUnderObservation", event = "event",
             rho1 = 0.5, rho2 = 0)
head(df)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
