% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsasim.R
\docType{package}
\name{lsasim}
\alias{lsasim}
\alias{lsasim-package}
\title{lsasim: A package for simulating large scale assessment data}
\description{
lsasim simulates data that mimics large-scale assessments (LSAs), including background questionnaire data and cognitive item responses that adhere to a multiple-matrix sampled design

Functions to Facilitate the Simulation of Large Scale Assessment Data
}
\note{
This package contains vignettes. If you are installing lsasim from GitHub, remember to use `build_vignettes=TRUE` in your `remotes::install_github()` call. Afterwards, you can browse the vignettes by issuing `browseVignettes("lsasim")` in your R terminal.
}
\section{Core functions}{

\itemize{
  \item \code{block_design} Assignment of test items to blocks.
  \item \code{booklet_design} Assignment of item blocks to test booklets.
  \item \code{booklet_sample} Assignment of test booklets to test takers.
  \item \code{item_gen} Generation of random correlation matrix.
  \item \code{proportion_gen} Generation of random cumulative proportions.
  \item \code{questionnaire_gen} Generation of ordinal and continuous variables.
  \item \code{response_gen} Generation of item response data using a rotated block design.
  \item \code{cluster_gen} Generation of background questionnaires from a cluster sampling scheme.
}
}

\section{Useful ancillary functions}{

\itemize{
  \item \code{irt_gen} Generate item responses from an IRT model.  Used by
  \code{response_gen}.
  \item \code{beta_gen} Calculates analytical and numeric regression
  coefficients for the background questionnaire responses as functions of the
  latent variable. Used by \code{questionnaire_gen}
}
}

\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/tmatta/lsasim/issues}
}

}
\author{
\strong{Maintainer}: Waldir Leoncio \email{w.l.netto@medisin.uio.no}

Authors:
\itemize{
  \item Tyler Matta \email{tyler.matta@gmail.com}
  \item Leslie Rutkowski \email{leslie.rutkowski@cemo.uio.no}
  \item David Rutkowski \email{david.rutkowski@cemo.uio.no}
  \item Yuan-Ling Linda Liaw \email{y.l.liaw@cemo.uio.no}
}

Other contributors:
\itemize{
  \item Kondwani Kajera Mughogho \email{k.k.mughogho@cemo.uio.no} [contributor]
  \item Sinan Yavuz [contributor]
  \item Paul Bailey [contributor]
}

}
