% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T3Clusf.R
\name{T3Clusf}
\alias{T3Clusf}
\title{T3Clusf: Tucker3 Fuzzy Cluster Analysis}
\usage{
T3Clusf(X, Q, R = Q, G = 2, margin = 3L, alpha = 1, eps = 1e-08,
  maxit = 100L, verbose = 1, nr.starts = 1L, parallel = TRUE,
  mc.cores = detectCores() - 1)
}
\arguments{
\item{X}{Three-way data array, with no missing values.}

\item{Q}{Integer giving the number of dimensions required for mode B (variables).
This is the first mode of the array, excluding the mode clustered over (see \code{margin}).}

\item{R}{Integer giving the number of dimensions required for mode C (occasions). 
This is the second mode of the array, excluding the mode clustered over (see \code{margin}).}

\item{G}{Integer giving the number of clusters required.}

\item{margin}{Integer giving the margin of the array to cluster over. The remaining two
modes, in the original order, corresponds to \code{Q} and \code{R}.}

\item{alpha}{Numeric value giving the fuzziness parameter.}

\item{eps}{Small numeric value giving the empirical convergence threshold.}

\item{maxit}{Integer giving the maximum number of iterations allowed.}

\item{verbose}{Integer giving the number of iterations after which the loss valus is printed.}

\item{nr.starts}{Integer giving the number of random starts required.}

\item{parallel}{Logical indicating whether to parallelize over random starts if 
\code{nr.starts > 1}.}

\item{mc.cores}{Argument passed to \code{\link{mclapply}}.}
}
\description{
This is an implementation of the T3Clusf algorithm of Rocci & Vichi (2005).
}
\examples{
data("dcars")
set.seed(13)
res <- T3Clusf(X = dcars, Q = 3, R = 2, G = 3, alpha = 2)

}
\references{
Rocci, R., & Vichi, M. (2005). \emph{Three-mode component analysis with crisp or fuzzy partition of units}. 
Psychometrika, 70(4), 715-736.
}

