% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthocPairwiseT.R
\name{posthocPairwiseT}
\alias{posthocPairwiseT}
\title{Post-hoc pairwise t-tests for ANOVA}
\usage{
posthocPairwiseT(x, ...)
}
\arguments{
\item{x}{An \code{aov} object}

\item{...}{Arguments to be passed to \code{pairwise.t.test}}
}
\value{
As per \code{pairwise.t.test}
}
\description{
Performs pairwise t-tests for an analysis of variance,
making corrections for multiple comparisons.
}
\details{
The intention behind this function is to allow users to use simple
tools for multiple corrections (e.g., Bonferroni, Holm) as post hoc
corrections in an ANOVA context, using the fitted model object (i.e., an
\code{aov} object) as the input. The reason for including this function is
that Tukey / Scheffe methods for constructing simultaneous confidence
intervals (as per \code{\link{TukeyHSD}}) are not often discussed in the
context of an introductory class, and the more powerful tools provided by
the \code{multcomp} package are not appropriate for students just beginning
to learn statistics.

This function is currently just a wrapper function for
\code{\link{pairwise.t.test}}, and it only works for one-way ANOVA, but
this may change in future versions.
}
\examples{
# create the data set to analyse:
dataset <- data.frame(
  outcome = c( 1,2,3, 2,3,4, 5,6,7 ),
  group = factor(c( "a","a","a", "b","b","b","c","c","c"))
)

# run the ANOVA and print out the ANOVA table:
anova1 <- aov( outcome ~ group, data = dataset )
summary(anova1)

# Currently, the following two commands are equivalent:
posthocPairwiseT( anova1 )
pairwise.t.test( dataset$outcome, dataset$group )

}
\seealso{
\code{\link{pairwise.t.test}},
\code{\link{TukeyHSD}}
}
