% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv}
\alias{cv}
\title{Calculate Coefficient of Variation}
\usage{
cv(x, na_rm = TRUE)
}
\arguments{
\item{x}{(numeric) vector of numbers for which to calculate CV}

\item{na_rm}{(logical) whether to remove missing values from both average and SD calculation}
}
\value{
(numeric) coefficient of variation
}
\description{
Computes the coefficient of variation (CV), by dividing the standard deviation (SD) by the arithmetic mean of a set of numbers. If \code{na_rm} is \code{TRUE} then missing values are removed before calculation is completed
}
\examples{
# Convert from Fahrenheit to Celsius
cv(x = c(4, 5, 6, 4, 5, 5), na_rm = TRUE)

}
