% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors-day.r
\name{day}
\alias{day}
\alias{day<-}
\alias{mday}
\alias{mday<-}
\alias{qday}
\alias{qday<-}
\alias{wday}
\alias{wday<-}
\alias{yday}
\alias{yday<-}
\title{Get/set days component of a date-time.}
\usage{
day(x)

mday(x)

wday(x, label = FALSE, abbr = TRUE)

qday(x)

yday(x)

day(x) <- value

mday(x) <- value

qday(x) <- value

wday(x) <- value

yday(x) <- value
}
\arguments{
\item{x}{a POSIXct, POSIXlt, Date, chron, yearmon, yearqtr, zoo, zooreg, timeDate, xts, its, ti,
jul, timeSeries, or fts object.}

\item{label}{logical. Only available for wday. TRUE will display the day of the week as an
ordered factor of character strings, such as "Sunday." FALSE will display the day of the week as a number.}

\item{abbr}{logical. Only available for wday. FALSE will display the day of the week as an
ordered factor of character strings, such as "Sunday." TRUE will display an abbreviated version of the
label, such as "Sun". abbr is disregarded if label = FALSE.}

\item{value}{a numeric object}
}
\value{
wday returns the day of the week as a decimal number
  (01-07, Sunday is 1) or an ordered factor (Sunday is first).
}
\description{
Get/set days component of a date-time.
}
\details{
\code{day} and \code{day<-} are aliases for \code{mday} and \code{mday<-} respectively.
}
\examples{
x <- as.Date("2009-09-02")
wday(x) #4

wday(ymd(080101))
# 3
wday(ymd(080101), label = TRUE, abbr = FALSE)
# "Tuesday"
# Levels: Sunday < Monday < Tuesday < Wednesday < Thursday < Friday < Saturday
wday(ymd(080101), label = TRUE, abbr = TRUE)
# "Tues"
# Levels: Sunday < Monday < Tuesday < Wednesday < Thursday < Friday < Saturday
wday(ymd(080101) + days(-2:4), label = TRUE, abbr = TRUE)
# "Sun"   "Mon"   "Tues"  "Wed"   "Thurs" "Fri"   "Sat"
# Levels: Sunday < Monday < Tuesday < Wednesday < Thursday < Friday < Saturday

x <- as.Date("2009-09-02")
yday(x) #245
mday(x) #2
yday(x) <- 1  #"2009-01-01"
yday(x) <- 366 #"2010-01-01"
mday(x) > 3
}
\seealso{
\code{\link{yday}}, \code{\link{mday}}
}
\keyword{chron}
\keyword{manip}
\keyword{methods}
\keyword{utilities}

