% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors-quarter.r
\name{quarter}
\alias{quarter}
\alias{semester}
\title{Get the fiscal quarter and semester of a date-time.}
\usage{
quarter(x, with_year = FALSE)

semester(x, with_year = FALSE)
}
\arguments{
\item{x}{a date-time object of class POSIXct, POSIXlt, Date, chron, yearmon,
yearqtr, zoo, zooreg, timeDate, xts, its, ti, jul, timeSeries, fts or
anything else that can be converted with as.POSIXlt}

\item{with_year}{logical indicating whether or not to include the quarter's
year.}
}
\value{
numeric
}
\description{
Quarters divide the year into fourths. Semesters divide the year into halfs.
}
\examples{
x <- ymd(c("2012-03-26", "2012-05-04", "2012-09-23", "2012-12-31"))
quarter(x)
quarter(x, with_year = TRUE)
semester(x)
semester(x, with_year = TRUE)
}

