% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lta.R
\name{lta}
\alias{lta}
\title{Latent Trait Analysis}
\usage{
lta(X, D, nstarts = 3, tol = 0.1^2, maxiter = 250, pdGH = 21)
}
\arguments{
\item{X}{(\code{N} x \code{M}) binary incidence matrix}

\item{D}{dimension of the continuous latent variable}

\item{nstarts}{number of starts.  Default \code{nstarts = 3}}

\item{tol}{desired tolerance for convergence. Default \code{tol = 0.1^2}}

\item{maxiter}{maximum number of iterations. Default \code{maxiter = 500}}

\item{pdGH}{number of quadrature points for the Gauss-Hermite quadrature. Default \code{pdGH = 21}}
}
\value{
List containing the following information for each model fitted:
\itemize{
\item \code{b} intercepts for the logistic response function
\item \code{w} slopes for the logistic response function
\item \code{mu} (\code{N} x \code{D}) matrix containing posterior means for the latent variable
\item \code{C} list of \code{N} (\code{D} x \code{D}) matrices containing posterior variances for the latent variable
\item \code{LL} log likelihood
\item \code{BIC} Bayesian Information Criterion (BIC) (Schwarz (1978))
}
If multiple models are fitted the output contains also a table to compare the BIC for all models fitted.
}
\description{
Latent trait analysis (LTA) can be used to model the dependence in the receiver nodes by using a continuous D-dimensional latent variable. The function \code{lta} makes use of a variational inferential approach. For more details see Gollini, I. (in press) and Gollini, I., and Murphy, T. B. (2014).
}
\examples{
### Simulate Bipartite Network
set.seed(1)
X <- matrix(rbinom(4 * 12, size = 1, prob = 0.4), nrow = 12, ncol = 4)

resLTA <- lta(X, D = 1:2) 
}
\references{
Gollini, I. (in press) 'A mixture model approach for clustering bipartite networks', Challenges in Social Network Research Volume in the Lecture Notes in Social Networks (LNSN - Series of Springer). Preprint: \url{https://arxiv.org/abs/1905.02659}.

Gollini, I., and Murphy, T. B. (2014), 'Mixture of Latent Trait Analyzers for Model-Based Clustering of Categorical Data', Statistics and Computing, 24(4), 569-588 \url{http://arxiv.org/abs/1301.2167}.
}
\seealso{
\code{\link{mlta}}
}
