% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute-attachment-fetch.R
\name{execute_attachment_fetch}
\alias{execute_attachment_fetch}
\title{Execution engine loop for all the fetch commands}
\usage{
execute_attachment_fetch(
  self,
  id,
  id_folder,
  df_meta_to_fetch,
  fetch_request,
  folder_clean,
  url_folder,
  content_disposition,
  override,
  retries
)
}
\arguments{
\item{self}{The R6 connection object.}

\item{id}{A message id obtained inside the main loop in \code{fetch_attachments_int}.}

\item{id_folder}{The name of the folder containing the message id.}

\item{df_meta_to_fetch}{A \code{data frame} returned by
\code{extract_MIME_level_and_filename()} containing the filenames, the
MIME level in which each attachment is, and the content-disposition of the
file.}

\item{fetch_request}{A string containing the fetch request to the server that
will be added to the curl handle.}

\item{folder_clean}{A \code{character} string containing the cleaned folder
name, which will be uses to create a local folder.}

\item{url_folder}{The name of the folder containing the message url of the IMAP server.}

\item{content_disposition}{A \code{string} indicating which type of
"Content-Disposition" attachments should be retrieved. The options are
\code{both}, \code{attachment}, and \code{inline}. Default is
\code{"both"}, which retrieves regular attachments ("Content-Disposition:
attachment") and  inline attachments ("Content-Disposition: inline").}

\item{override}{A \code{logical}. If \code{TRUE}, overrides existent files
containing the same name in the local directory. Default is \code{FALSE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{1}.
@noRd}
}
\description{
Execution engine loop for all the fetch commands
}
